<?php

use Mtc\Shop\Brand;

$path = '../../../';
require_once $path.'core/includes/header.inc.php';

$page_meta['title'] = 'Manage SEO Brands';

$seoBrands = new SeoBrands();
$errors = array();
$form = array();

if ($_REQUEST['delete']) {
    $seoBrands->deleteBrand($_REQUEST['delete']);
    header('Location: manage.seo.brands.php?message=success');
    exit();
}

if ($_REQUEST['edit']) {
    $form = $seoBrands->getBrand($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {
    $form['title'] = $_REQUEST['title'];
    $form['description'] = $_REQUEST['description'];

    if (count($errors) === 0) {
        $seoBrands->updateBrand($_REQUEST['id'], $_REQUEST['title'], $_REQUEST['description']);
        header('Location: manage.seo.brands.php?message=success');
        exit();
    }
}

if ($_REQUEST['action'] == 'csv') {
    if (!empty($_REQUEST['export'])) {
        header('Location: csv.get.php?type=brands');
        exit;
    } elseif (!empty($_REQUEST['import'])) {
        SeoCsv::importCsv('brands');
        header('Location: manage.seo.brands.php?message=success');
        exit;
    }
}

$brands = Brand::query()
    ->orderBy('name')
    ->get()
    ->toArray();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Brands</h1>
<?php
include 'tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}

include __DIR__.'/templates/csvform.html.php';
?>

<?php
if ($_REQUEST['edit']) {
    ?>
    <form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
        <fieldset>
            <div class="row">
                <label for="path">Brand</label>
                <?= clean_page($form['name']) ?>
                <input type="hidden" name="id" value="<?= clean_page($form['id']) ?>" />
            </div>
            <div class="row">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" value="<?= clean_page($form['title']); ?>">
            </div>
            <div class="row">
                <label for="description">Description</label>
                <input type="text" name="description" id="description" value="<?= clean_page($form['description']); ?>">
            </div>
            <input type="hidden" name="action" value="update">
            <?php
            if ($_REQUEST['edit']) {
                ?>
                <input type="hidden" name="edit" value="<?= $_REQUEST['edit'] ?>">
                <?php

            }
            ?>
            <div class="search-button"><input type="submit" value="<?php
            if (!$_REQUEST['edit']) {
                echo 'Add';
            } else {
                echo 'Edit';
            }
            ?>" class="BUTTON"/></div>
        </fieldset>
    </form>
    <?php

}

if (!$_REQUEST['edit'] && count($brands) > 0) {
    ?>
    <table>
        <tr>
            <th class="center"></th>
            <th>Brand</th>
            <th>Title</th>
            <th>Description</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($brands as $brand) {
                ?>
                <tr>
                    <td>
                        <a href="<?= browse_url(0, $brand['id']) ?>" target="_blank"><i class="fa fa-eye"></i></a>
                    </td>
                    <td><?= clean_page($brand['name']) ?></td>
                    <td><?= clean_page($brand['seo_title']) ?></td>
                    <td><?= clean_page($brand['seo_description']) ?></td>
                    <td>
                        <a href="?edit=<?= $brand['id'] ?>"><i class="fa fa-pencil"></i></a>
                        &nbsp;
                        <a href="?delete=<?= $brand['id'] ?>" class="alert error" title="Are you sure you want to delete this seo entry?"><i class="fa fa-times-circle"></i></a>
                    </td>
                </tr>
                <?php

            }
    ?>
        </tbody>
    </table>

    <?php

}
require_once $path . 'core/admin/templates/adminfooter.html.php';
