<?php

$path = '../../../';
require $path.'core/includes/header.inc.php';

init_request_values([
    'path' => null,
    'title' => null,
    'description' => null,
]);

$page_meta['title'] = 'Manage SEO Pages';

$seoPages = new SeoPages();
$errors = array();
$form = array();

if ($_REQUEST['delete']) {
    $seoPages->deletePage($_REQUEST['delete']);
    header('Location: manage.seo.pages.php?message=success');
    exit();
}

if ($_REQUEST['edit']) {
    $form = $seoPages->getPage($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {
    $form['path'] = $_REQUEST['path'];
    $form['title'] = $_REQUEST['title'];
    $form['description'] = $_REQUEST['description'];

    if (!preg_match('#^/#', $_REQUEST['path'])) {
        $errors[] = 'Your path has to start with a forward slash: /';
    }

    if ($_REQUEST['path'] == '/') {
        $errors[] = 'Use /index.php for home';
    }

    if (count($errors) === 0) {
        $seoPages->createOrUpdate($_REQUEST['path'], $_REQUEST['title'], $_REQUEST['description']);
        header('Location: manage.seo.pages.php?message=success');
        exit;
    }
}

if ($_REQUEST['action'] == 'csv') {
    if (!empty($_REQUEST['export'])) {
        header('Location: csv.get.php?type=paths');
        exit();
    } elseif (!empty($_REQUEST['import'])) {
        SeoCsv::importCsv('paths');
        header('Location: manage.seo.pages.php?message=success');
        exit;
    }
}

$seoPages->getPages();

/* * ***********************************************************************************************************************************
 * 														OUTPUT
 * *********************************************************************************************************************************** */

include $path.'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Pages</h1>
<?php
include 'tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}

include __DIR__.'/templates/csvform.html.php';
?>

<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
    <fieldset>
        <?php
        if (!$_REQUEST['edit']) {
            ?>
            <h1><a class="show el">Add Rule<i class="fa fa-caret-right"></i></a></h1>
            <?php

        }
        ?>
        <div class="row">
            <label for="path">Path</label>
            <?php
            if (!$_REQUEST['edit']) {
                ?>
                <input type="text" name="path" id="path" value="<?= clean_page($_REQUEST['path']);
                ?>">
                <div class="hint el">
                    <i class="fa fa-info-circle"></i>
                    <div style="display: none;" class="text">
                        <h1>Page Path</h1>
                        <p>
                            Link to the page you want to set SEO data for starting with the / after the .co.uk or .com etc
                            <br />Use /index.php for the homepage
                        </p>
                    </div>
                </div>
                <?php

            } else {
                echo clean_page($form['path']);
                ?>
                <input type="hidden" name="path" value="<?= clean_page($form['path']) ?>" />
                <?php

            }
            ?>
        </div>
        <div class="row">
            <label for="title">Title</label>
            <input type="text" name="title" id="title" value="<?= $form ? $form['title'] : clean_page($_REQUEST['title']); ?>">
        </div>
        <div class="row">
            <label for="description">Description</label>
            <input type="text" name="description" id="description" value="<?= $form ? $form['description'] : clean_page($_REQUEST['description']); ?>">
        </div>
        <input type="hidden" name="action" value="update">
        <input type="submit" class="btn" value="Save"/>
        <?php
        if ($_REQUEST['edit']) {
            ?>
            <input type="hidden" name="edit" value="<?= $_REQUEST['edit'] ?>">
            <?php

        }
        ?>
    </fieldset>
</form>

<?php
if (!$_REQUEST['edit'] && count($seoPages->seo_pages) > 0) {
    ?>
    <table class="">
        <tr>
            <th class="center"></th>
            <th>Path</th>
            <th>Title</th>
            <th>Description</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">
            <?php
            foreach ($seoPages->seo_pages as $page) {
                ?>
                <tr>
                    <td>
                        <a href="<?= $page['path'] ?>" target="_blank"><i class="fa fa-eye"></i></a>
                    </td>
                    <td><?= clean_page($page['path']) ?></td>
                    <td><?= clean_page($page['title']) ?></td>
                    <td><?= clean_page($page['description']) ?></td>
                    <td>
                        <a href="?edit=<?= $page['id'] ?>"><i class="fa fa-pencil"></i></a>
                        &nbsp;
                        <a href="?delete=<?= $page['id'] ?>" class="alert error" title="Are you sure you want to delete this seo entry?"><i class="fa fa-times-circle"></i></a>
                    </td>
                </tr>
                <?php

            }
    ?>
        </tbody>
    </table>

    <?php

}
require_once $path.'core/admin/templates/adminfooter.html.php';
