<?php

use Spatie\ImageOptimizer\OptimizerChainFactory;


class ImageOptimizer
{
    /**
    * optimizeLosslessly method
    *
    * This method will attempt to losslessly optimise an image. If it
    * succeeds, it will then overwrite the original one with the new optimised.
    *
    * @param string $filepath
    * @param boolean $enabled
    */
    public static function optimizeLosslessly($filepath, $enabled = IMAGE_OPTIMISE_LOSSLESS)
    {
        $optimizerChain = OptimizerChainFactory::create();
        $optimizerChain->optimize($filepath);
    }

    /**
     * Runs imagemagick's convert command to strip EXIF and reduce quality to 85%
     *
     * @param mixed $file
     * @return mixed $result
     */
    public static function optimizeLossy($filepath)
    {
        $command = IMAGE_CONVERT . " {$filepath} -strip -quality 85 {$filepath}";
        return shell_exec($command);
    }
}
