<?php

namespace Mtc\Core;

/*
 * @author Jack Donaldson - jack.donaldson@mtcmedia.co.uk
 * @version 10.03.2017
 *
 * This class is used to determine which validation method to use for a postcode.
 * It detects which country the post code would be used for will run the correct validation method
 * Currently, it will only separate UK postcodes from the any other countries but this allows expansion at a later date
 *
 * @param string $postcode_string Postcode as string Expected Input: "12345", "1234", "LT-12345", "12345-1234", "DD1 3JA"
 *
 * @param string $country_code Country Code as string Expected Input: 'IE', 'DE' or 'US'
 */

require_once('Postcode.php');

class PostcodeFactory
{
    public static function build($postcode_string, $country_code)
    {
        if (strtoupper($country_code) === 'GB') {

            return new UkPostcode($postcode_string);

        } else {

            return new GenericPostcode($postcode_string, $country_code);

        }

    }
}