<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Mtc\Core\Admin\User;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class AdminUserFactory extends Factory
{
    // Has relationships...
    protected $model = User::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'username' => fake()->userName(),
            'password' => '',
            'email' => fake()->userName() . '@pharmacy.com',
            'signature' => '',
            'session_id' => '',
            'name' => fake()->name(),
            'last_login' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
            'last_updated' => fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s'),
        ];
    }

    function doctor()
    {
        return $this->state(function (array $attributes) {
            return [
                'role' => 3,
            ];
        });
    }

    function pharmacist()
    {
        return $this->state(function (array $attributes) {
            return [
                'role' => 4,
            ];
        });
    }

    function shop_manager()
    {
        return $this->state(function (array $attributes) {
            return [
                'role' => 7,
            ];
        });
    }

    function nhs_pharmacist()
    {
        return $this->state(function (array $attributes) {
            return [
                'role' => 8,
            ];
        });
    }

    function private_pharmacist()
    {
        return $this->state(function (array $attributes) {
            return [
                'role' => 9,
            ];
        });
    }
}
