<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Mtc\Modules\Members\Models\Member;

class MemberFactory extends Factory
{
    protected $model = Member::class;

    public function definition(): array
    {
        // Reuse one timestamp for the row (the seeder will usually override these anyway)
        $ts = fake()->dateTimeBetween('-1 month', 'now')->format('Y-m-d H:i:s');

        // Build small random subsets (fast)
        $pick = function(array $pool, int $max): string {
            $n = random_int(0, $max);
            if ($n === 0) return '[]';
            $keys = array_rand($pool, $n);
            $vals = is_array($keys) ? array_values(array_intersect_key($pool, array_flip($keys))) : [$pool[$keys]];
            return json_encode($vals, JSON_UNESCAPED_UNICODE);
        };

        $conditionsPool  = ['Asthma','Diabetes','High blood pressure','Anxiety','Depression','Arthritis','Heart condition'];
        $medicationsPool = ['Ibuprofen','Metformin','Paracetamol','Lisinopril','Atorvastatin','Omeprazole'];
        $allergiesPool   = ['Peanuts','Shellfish','Penicillin','Dust mites','Latex','Pollen'];

        // Keep DOB simple; seeder can override if needed
        $dob = fake()->dateTimeBetween('-80 years', '-18 years')->format('Y-m-d');

        return [
            // email is set by seeder via ->sequence(); keep a fallback here
            'email'                     => fake()->safeEmail(),
            'password'                  => Hash::make('Password123'), // seeder overrides with a precomputed hash
            'contact_no'                => fake()->numerify('07#########'),
            'hash'                      => '',
            'conditions'                => $pick($conditionsPool, 3),
            'medications'               => $pick($medicationsPool, 3),
            'allergies'                 => $pick($allergiesPool, 2),
            'basket_id'                 => 0,
            'optout'                    => 0,
            'prescription_reminder_email' => 0,
            'prescription_reminder_sms'   => 0,
            'last_login'                => $ts,
            'last_failed_login'         => $ts,
            'failed_login_count'        => 0,
            'created_at'                => $ts,
            'updated_at'                => $ts,
            'first_login'               => $ts,
            'account_verified'          => $ts,
            'verification_code'         => '',
            'verification_code_expiry'  => '',
            'phone_prefix'              => '+44',
            'passed_id_check'           => null,
            'dob'                       => $dob,
            'gender'                    => fake()->randomElement(['Male', 'Female']),
            'height'                    => null,
            'doctor_surgery'            => '',
            'has_nominated_client_as_pharmacy_of_choice' => 0,
            'confirmed_terms_at'        => null,
        ];
    }
}
