<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Mtc\Shop\Order;

class OrderStripeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::disableQueryLog();
        DB::table('order_stripe')->truncate();

        // INSERT … SELECT with SQL-side generated pseudo-random strings
        // 24-char base36 strings derived from id + NOW()
        DB::statement("
            INSERT INTO order_stripe (order_id, charge_id, order_ref, `timestamp`, amount)
            SELECT  o.id,
                    LPAD(CONV(FLOOR(RAND(o.id)*POW(36,24)),10,36),24,'0') AS charge_id,
                    LPAD(CONV(FLOOR(RAND(o.id+12345)*POW(36,24)),10,36),24,'0') AS order_ref,
                    NOW(),
                    o.cost_total
            FROM `order` o
        ");
    }
}
