<?php
/**
 * Ajax to get form data
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Modules\FormBuilder\Classes;

$path = '../../../../';
require_once $path . 'core/includes/header.inc.php';

if (!empty($_REQUEST['form_id'])) {
    $form = Form::where('id', $_REQUEST['form_id'])
        ->with('questions.options')
        ->with('questions.notifications')
        ->with('fieldsets.questions')
        ->first();
    $question = FormQuestion::getEmpty();
    $fieldset = FormFieldset::getEmpty();
    $option = FormQuestionOption::getEmpty();
    $email = FormQuestionEmail::getEmpty();
    echo json_encode([
        'form' => $form,
        'empty_question' => $question,
        'empty_fieldset' => $fieldset,
        'empty_option' => $option,
        'empty_email' => $email
    ]);
    exit;
} elseif (isset($_REQUEST['get_empty_form'])) {
    $form = Form::getEmpty();
    $question = FormQuestion::getEmpty();
    $fieldset = FormFieldset::getEmpty();
    $option = FormQuestionOption::getEmpty();
    $email = FormQuestionEmail::getEmpty();
    echo json_encode([
        'form' => $form,
        'empty_question' => $question,
        'empty_fieldset' => $fieldset,
        'empty_option' => $option,
        'empty_email' => $email
    ]);
    exit;
}
http_response_code(404);
exit;