<?php
/**
 * Members Section
 *
 * Provide a basic members section for standalone use.
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

if (!defined('MEMBERS_SECTION')) {
    require_once __DIR__ . '/admin/includes/install.php';
}

// Check if Member is logged in
if (defined('MEMBERS_SECTION') && MEMBERS_SECTION === true) {


    // add instance for the Auth facade
    \Illuminate\Support\Facades\App::bind('members_auth', function ($app) {
        return new \Mtc\Modules\Members\Classes\Authenticator();
    });

    $member = \Mtc\Modules\Members\Classes\Auth::getLoggedInMember();

    $twig->addGlobal('member', $member);
} else {
    //check if MEMBERS_SECTION constant is true and currently under members section, redirect if otherwise
    if (\Mtc\Modules\Members\Models\Member::inMembersUrl()) {
        header("Location: /");
        exit();
    }
}
