    /**
    * $http shim for Vue (vue-resource-like).
    * - GET/POST support
    * - Auto handles FormData (no manual Content-Type)
    * - x-www-form-urlencoded by default for plain objects
    * - JSON if headers['Content-Type'] === 'application/json' or options.json === true
    * - Adds X-Requested-With and X-CSRF-TOKEN (Laravel)
    * - Parses JSON automatically; returns { data, raw, status, ok, headers }
    */
    (function () {
    if (!window.Vue) return;

    // If axios is present and you’d rather use it, uncomment:
    // if (window.axios) { Vue.prototype.$http = window.axios; return; }

    function qs(obj) {
    const pairs = [];
    Object.keys(obj || {}).forEach(k => {
    const v = obj[k];
    const val = (v !== null && typeof v === 'object') ? JSON.stringify(v) : (v ?? '');
    pairs.push(encodeURIComponent(k) + '=' + encodeURIComponent(val));
});
    return pairs.join('&');
}

    function pickCsrf() {
    const m = document.querySelector('meta[name="csrf-token"]');
    return m ? m.getAttribute('content') : null;
}

    function normalizeResponse(res, text) {
    let data = text;
    try { data = JSON.parse(text); } catch (_) { /* not JSON, leave as text */ }
    return {
    data,             // parsed JSON when possible, else string
    raw: text,        // always the original text
    status: res.status,
    ok: res.ok,
    headers: res.headers
};
}

    function request(method, url, payload, options) {
    options = options || {};
    const headers = Object.assign(
{
    'X-Requested-With': 'XMLHttpRequest'
},
    options.headers || {}
    );
    const csrf = pickCsrf();
    if (csrf) headers['X-CSRF-TOKEN'] = csrf;

    const init = {
    method: method.toUpperCase(),
    headers,
    credentials: 'same-origin'
};

    // Handle query for GET
    if (init.method === 'GET') {
    if (payload && typeof payload === 'object' && Object.keys(payload).length) {
    const sep = url.indexOf('?') === -1 ? '?' : '&';
    url += sep + qs(payload);
}
} else {
    // POST / others
    if (payload instanceof FormData) {
    // Let the browser set multipart boundaries; do NOT set Content-Type
    delete headers['Content-Type'];
    init.body = payload;
} else if (options.json === true || headers['Content-Type'] === 'application/json') {
    headers['Content-Type'] = 'application/json;charset=UTF-8';
    init.body = JSON.stringify(payload || {});
} else {
    headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8';
    init.body = qs(payload || {});
}
}

    return fetch(url, init)
    .then(res => res.text().then(text => normalizeResponse(res, text)));
}

    Vue.prototype.$http = {
    get: function (url, params, options) {
    return request('GET', url, params, options);
},
    post: function (url, payload, options) {
    return request('POST', url, payload, options);
}
};
})();
