<?php
/**
 * Customers Also Viewed Plugin
 *
 * Show related products that were viewed at the same time as other products
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

use \Mtc\Plugins\CustomersAlsoViewed\Classes\CustomersAlsoViewed;

if (!defined('CUSTOMERS_ALSO_VIEWED_ENABLE')) {
    require_once __DIR__ . '/admin/includes/install.php';
}

if (defined('CUSTOMERS_ALSO_VIEWED_ENABLE') && CUSTOMERS_ALSO_VIEWED_ENABLE === true) {

    HooksAdapter::add_action(
        'render_item',
        'Mtc\Plugins\CustomersAlsoViewed\Classes\CustomersAlsoViewed::registerItemView',
        10
    );

}

// Add twig function to allow calling via {{ customers_also_viewed($limit, $item_id) }}
$twig->addFunction(
    new \Twig\TwigFunction(
        'customers_also_viewed', function ($limit = 4, $item_id = 0) use ($twig) {

            if (defined('CUSTOMERS_ALSO_VIEWED_ENABLE') && CUSTOMERS_ALSO_VIEWED_ENABLE === true) {
                $customers_also_viewed = CustomersAlsoViewed::getAlsoViewed($twig, $limit, $item_id);
                return $twig->render('shop/item/customers_also_viewed.twig', compact('customers_also_viewed'));
            }
        }

    )
);
