<?php

namespace Mtc\Plugins\DeliveryCouriers\Classes;

use Illuminate\Database\Eloquent\Model;

/**
 * Class CourierCollectLocation
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class DeliveryCourier extends Model
{
    /**
     * Table for storing entries
     *
     * @var string $table
     */
    protected $table = 'delivery_couriers';

    /**
     * Mass assignable fields
     *
     * @var string[] $fillable
     */
    protected $fillable = [
        'api_courier_id',
        'active',
        'username',
        'password',
        'account_number',
        'pickup_delay_days',
        'pickup_time_window_start',
        'pickup_time_window_end',
        'package_weight_threshold',
        'default_package_length',
        'default_package_width',
        'default_package_height',
        'label_format',
    ];
}