<?php
/**
 * Feefo Reviews Installer
 *
 * This code is used to Feefo Reviews on site
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   Davis Lasis <davis.lasis@mtcmedia.co.uk>
 * @version  v3.0
 */

if (empty($path)) {
    $path = '../../../../';
    require_once $path . "core/includes/header.inc.php";
    $display_message = true;
}

use Illuminate\Database\Capsule\Manager as Capsule;

$plugin_title = 'Feefo Reviews';

$schema = Capsule::connection()->getSchemaBuilder();

if ($schema->hasTable('feefo_reviews_logs') === false) {
    $schema->create(
        'feefo_reviews_logs',
        function ($table) {
            $table->increments('id')->unsigned;
            $table->text('request');
            $table->text('response');
            $table->timestamps();
        }
    );
}

if ($schema->hasTable('feefo_reviews_settings') === false) {
    $schema->create(
        'feefo_reviews_settings',
        function ($table) {
            $table->increments('id')->unsigned;
            $table->string('name');
            $table->string('url');
            $table->string('telephone');
            $table->string('streetAddress');
            $table->string('addressLocality');
            $table->string('addressLocality2');
            $table->string('addressCountry');
            $table->timestamps();
        }
    );

    Capsule::table('feefo_reviews_settings')->insert(
        [
            'name' => config('app.name'),
            'url' => SITE_URL,
            'telephone' => '',
            'streetAddress' => '',
            'addressLocality' => '',
            'addressLocality2' => '',
            'addressCountry' => 'United Kingdom',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ]
    );

}

// Get the path to the admin folder without public_html / fork directory
$path_to_admin_folder = str_replace(SITE_PATH, '', dirname(__DIR__)) . '/admin/';

if (!Capsule::table('admin_menu')->where('title', '=', $plugin_title)->exists()) {
    // Create the admin menu item
    $menu_id = Capsule::table('admin_menu')->insertGetId([
        'sub_id'     => 0,
        'title'      => $plugin_title,
        'path'       => '',
        'activePath' => '',
        'constant'   => 'FEEFO_REVIEWS_ENABLED',
        'icon'       => '',
        'new_window' => 0,
        'order'      => 4
    ]);

    Capsule::table('admin_menu')->insertGetId([
        'sub_id'     => $menu_id,
        'title'      => $plugin_title,
        'path'       => $path_to_admin_folder,
        'activePath' => $path_to_admin_folder,
        'constant'   => 'FEEFO_REVIEWS_ENABLED',
        'icon'       => 'fa fa-commenting',
        'new_window' => 0,
        'order'      => 1
    ]);
}

$settings = [
    [
        'key'         => 'FEEFO_REVIEWS_ENABLED',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => $plugin_title,
        'description' => 'Turn on/off '.$plugin_title,
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_MERCHANT_IDENTIFIER',
        'type'        => 'string',
        'value'       => 'example-retail-merchant',
        'module'      => $plugin_title,
        'description' => 'This is used to identify your account in any sales data you send to Feefo and any integration methods you use to display reviews on your website.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_API_KEY',
        'type'        => 'string',
        'value'       => '2de0a1ad-331b-49b1-a3d2-39a908c05209',
        'module'      => $plugin_title,
        'description' => 'This is used to authenticate your account for any secure integrations with Feefo such as the Enter Sales Remotely sale submission method and the secure version of the XML feed.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_BADGE_TEMPLATE',
        'type'        => 'string',
        'value'       => 'service-stars-white-231x58_en.png',
        'module'      => $plugin_title,
        'description' => 'Homepage Feefo badge template. Options can be found here https://support.feefo.com/support/solutions/articles/8000042108-feefo-badges and http://www.feefo.com/feefo/selectlogotemplate.jsp',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_ITEM_REVIEWS',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => $plugin_title,
        'description' => 'This option turns on / off Feefo reviews tab for item full view.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_LATEST_REVIEWS',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => $plugin_title,
        'description' => 'This option turns on / off Feefo reviews list for homepage view.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_LOG_ALL_REQUESTS',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => $plugin_title,
        'description' => 'This option turns on / off all request and response log functionality, but system will write failed requests at all times even if turned off.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_ENTER_SALES_REMOTELY',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => $plugin_title,
        'description' => 'This option turns on / off functionality that sends sales data to Feefo server after each successfull order.',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_API_ENTER_SALES_REMOTELY_URL',
        'type'        => 'string',
        'value'       => 'https://api.feefo.com/api/entersaleremotely',
        'module'      => $plugin_title,
        'description' => 'No need to change this unless Feefo changes it with newer version. https://support.feefo.com/support/solutions/articles/8000041823-entersaleremotely-api-introduction',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'FEEFO_REVIEWS_API_SUMMARY_URL',
        'type'        => 'string',
        'value'       => 'http://api.feefo.com/api/10/reviews/summary/service',
        'module'      => $plugin_title,
        'description' => 'No need to change this unless Feefo changes it with newer version.',
        'created_at'  => new DateTime(),
    ],
];

// Install Feefo Reviews settings
if (!empty($settings)) {
    foreach ($settings as $data) {
        if (!defined($data['key'])) {
            Setting::Insert($data);
        }
    }
}

if ($display_message === true) {
    exit('Install successful');
}
