<?php

use \Mtc\Plugins\NHS\Classes\NHSMember;
use \Mtc\Modules\DoctorSurgery\Classes\DoctorSurgery;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$display_form = true;

$errors = [];

if (!$nhs_member = (new NHSMember())->find($_REQUEST['id'])) {
    header('location: index.php');
    exit;
}

$addedit = $_REQUEST['id'] ? 'Update' : 'Add';

$page_meta['title'] = $addedit . ' NHS Member';

if ($_REQUEST['action'] === 'save') {
    if (empty($_REQUEST['firstname'])) {
        $errors['firstname'] = 'Firstname is required!';
    }
    if (empty($_REQUEST['lastname'])) {
        $errors['lastname'] = 'Lastname is required!';
    }
    if ($_REQUEST['gender'] === '') {
        $errors['gender'] = 'Gender is required!';
    }
    if ($_REQUEST['doctor_surgery_id'] === '') {
        $errors['doctor_surgery_id'] = 'Doctor Surgery is required!';
    }
    if (empty($errors)) {
        $nhs_member->dob = $_REQUEST['dob_year'] . '-' . $_REQUEST['dob_month'] . '-' . $_REQUEST['dob_day'];
        $nhs_member->fill($_REQUEST);
        $nhs_member->save();
        header('location: /plugins/NHS/admin/manage_nhs_member.php?id=' . $_REQUEST['id']);
        exit;
    }
}

$dob = explode('-', $nhs_member->dob);
$nhs_member->dob_year = $dob[0];
$nhs_member->dob_month= $dob[1];
$nhs_member->dob_day = $dob[2];

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li><a href="manage_nhs_member.php">Manage NHS Members</a> /</li>
        <li class="end"><?= clean_page($page_meta['title']) ?></li>
    </ul>

    <h1>NHS Member</h1>
<?php

include __DIR__ . '/tabnav.php';

if (count($errors)>0) {
    showerrors($errors);
}

?>

    <form action="" method="post" class="style">
        <fieldset class="show">
            <h1><a class="show el">NHS Member Data <i class="fa fa-caret-right"></i></a></h1>
            <div class="row">
                <label for="nhs_number">NHS Number</label>
                <input type="text" name="nhs_number" id="nhs_number" value="<?= clean_page($nhs_member->nhs_number) ?>" />
            </div>
            <div class="row">
                <label for="firstname">Firstname</label>
                <input type="text" name="firstname" id="firstname" value="<?= clean_page($nhs_member->firstname) ?>" />
            </div>
            <div class="row">
                <label for="lastname">Lastname</label>
                <input type="text" name="lastname" id="lastname" value="<?= clean_page($nhs_member->lastname) ?>" />
            </div>
            <div class="row">
                <label for="is_pay_for_prescriptions">Pays for prescriptions</label>
                <select name="is_pay_for_prescriptions" id="is_pay_for_prescriptions">
                    <option value="">Not specified</option>
                    <option value="0" <?= $nhs_member->is_pay_for_prescriptions === 0 ? 'selected' : ''; ?>>No</option>
                    <option value="1" <?= $nhs_member->is_pay_for_prescriptions === 1 ? 'selected' : ''; ?>>Yes</option>
                </select>
            </div>
            <div class="row">
                <label for="pay_explanation">Reason why doesn't pay for prescriptions</label>
                <input type="text" name="pay_explanation" id="pay_explanation" value="<?= clean_page($nhs_member->pay_explanation) ?>" />
            </div>
            <div class="row">
                <label for="is_patient">NHS Member Type</label>
                <select name="is_patient" id="is_patient">
                    <option value="">Not specified</option>
                    <option value="1" <?= $nhs_member->is_patient === 1 ? 'selected' : ''; ?>>Patient</option>
                    <option value="0" <?= $nhs_member->is_patient === 0 ? 'selected' : ''; ?>>Representative</option>
                </select>
            </div>
            <div class="row">
                <label for="gender">Gender</label>
                <select name="gender" id="gender">
                    <option value="">Not specified</option>
                    <option value="male" <?= $nhs_member->gender === 'male' ? 'selected' : ''; ?>>Male</option>
                    <option value="female" <?= $nhs_member->gender === 'female' ? 'selected' : ''; ?>>Female</option>
                </select>
            </div>
            <div class="row">
                <label for="dob">Date of birth:</label>
                <select name="dob_day" id="dob_day" class="short" style="max-width:100px;">
                    <option value="">Not specified</option>
                    <?php
                    for ($i = 1; $i <= 31; $i++) {
                        $selected = $i == $nhs_member->dob_day ? 'selected' : '';
                        echo "<option value='{$i}' {$selected}>{$i}</option>";
                    }
                    ?>
                </select>
                <select name="dob_month" id="dob_month" class="short" style="max-width:100px;">
                    <option value="">Not specified</option>
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        $selected = $i == $nhs_member->dob_month ? 'selected' : '';
                        echo "<option value='{$i}' {$selected}>" . date('M', strtotime("2017-{$i}-01")) . "</option>";
                    }
                    ?>
                </select>
                <select name="dob_year" id="dob_year" class="short" style="max-width:100px;">
                    <option value="">Not specified</option>
                    <?php
                    for ($i = 1900, $thisYear = date('Y'); $i <= $thisYear; $i++) {
                        $selected = $i == $nhs_member->dob_year ? 'selected' : '';
                        echo "<option value='{$i}' {$selected}>{$i}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="row">
                <label for="doctor_surgery_id">Doctor Surgery</label>
                <select name="doctor_surgery_id" id="doctor_surgery_id">
                    <option value="">Not specified</option>
                    <?php
                    foreach (DoctorSurgery::query()->orderBy('practice_name')->get() as $doctor_surgery) {
                        $selected = $nhs_member->doctor_surgery_id === $doctor_surgery->id ? 'selected' : '';
                        echo "<option value='{$doctor_surgery->id}' {$selected}>{$doctor_surgery->practice_name} ({$doctor_surgery->area_team_name})</option>";
                    }
                    ?>
                </select>
            </div>
        </fieldset>
        <fieldset>
            <div class="save-button">
                <input type="hidden" name="action" value="save"/>
                <input type="submit" value="Save"/>
            </div>
        </fieldset>
    </form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
