
import Vue from 'vue';

Vue.component('nhs-prescriptions', {
    data: function() {
        return {
            dosages: [],
            prescriptions: [],
            medications: [],
            editing: false,
            resource: '/members/nhs/prescriptions/ajax.php'
        }
         ;
    },
    created: function() {
        // Get the user's current medication.
        this.$http.get(this.resource).then(function(response) {
            this.prescriptions = response.data.prescriptions;
            this.dosages = response.data.dosages;
        });

        // Warn if still editing this and the user hasn't pressed 'Save'.
        var instance = this;
        window.onbeforeunload = function() {
            if (instance.editing) {
                return 'Your changes will not be saved';
            }
        };

    },
    methods: {
        calculateExpiry: function (item) {
            // Dosage might have been changed
            var dosage = this.dosages.filter(function (dosage) {
                return dosage.id == item.dosage_id;
            })[0];

            // Find out whether there are past orders for this item that has the refill date in the future
            // and add the number of days to refill date.
            /*
            this.$http.post(this.resource, {
                action: 'addition_to_refill_date',
                item: item.name
            }).then(function(response) {
                var qty_last = parseInt(response.data);

                if (item.dosage.quantity_per_day > 0 && item.quantity_per_dose > 0) {
                    qty_last += parseInt(item.quantity) / parseInt(item.quantity_per_dose) / parseFloat(dosage.quantity_per_day);
                }

                item.refill_date = moment().add(qty_last, 'days').format('DD/MM/Y');
            });*/

            if (item.prescription_ends !== null) {
                this.$http.post(this.resource, {
                    action: 'get_current_medication_due',
                    item: item.name
                }).then(function(response) {
                    console.log(response);
                    if (response.data.status === 'ok') {
                        item.prescription_ends = response.data.due_date;
                    }
                });
            }


        },
        // Add a blank line
        addBlank: function() {

            var dID = 0;

            if(typeof this.dosages.length > 0) {
                dID = this.dosages[0].id;
            }
            this.prescriptions.push({
                name: '',
                quantity: '',
                quantity_per_dose: '1',
                dosage_id: dID,
                dosage: this.dosages[0],
                refill_date: ''
            });
        },
        // Use datalist to create a list of medications in an autocomplete
        getMedications: function(name) {
            if (name.length < 3) {
                this.medications = [];
                return true;
            }

            var instance = this;
            this.$http.post(this.resource, {search: name}).then(function(response) {
                instance.medications = response.data;
            });
        },
        confirmDeliveryDate: function(item) {
            /*
            This is a function which might be needed to confirm when the particular prescription is needed
             */
        },
        // Enable the 'edit' mode and add a blank prescription if this doesn't exist
        edit: function() {
            var handle = this;
            this.editing = true;
            if (this.prescriptions.length === 0) {
                this.addBlank();
            }
        },
        // Save a user's prescriptions
        save: function() {
            this.$http.post(this.resource, {action: 'save', data: this.prescriptions}).then(function(response) {
                this.prescriptions = response.data.prescriptions;
                this.editing = false;
            })
        }
    }
});

Vue.directive('nhs-confirm-overlay', {
    bind: function () {
        var el = $(this.el);
        el.mtcOverlay({
            content_class: '',
            max_width: 600,
            margin_vertical: 5,
            margin_horizontal: 5,
            onOpen: function () {
                $('#nhsCheckoutNotificationCancel').on('click', function () {
                    $('.overlayCloseButton').trigger('click');
                });
                $('#nhsCheckoutNotificationConfirm').on('click', function () {
                    $('#newPrescriptionDate').val($('#newPrescriptionDateField').val());
                    $('#nhsPrescriptionsForm').submit();
                });
            }
        });
    }
});
