<?php
/**
 * NHS plugin
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */



/*** ROUTES ***/

Route::any('nhs-prescriptions/welcome', [
    'as' => 'nhs-prescriptions-welcome',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\PrescriptionsController@welcome'
]);

Route::any('nhs-prescriptions/create', [
    'as' => 'nhs-prescriptions-create',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\PrescriptionsController@create'
]);

Route::any('nhs-prescriptions/edit/{uuid}', [
    'as' => 'nhs-prescriptions-edit',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\PrescriptionsController@edit'
]);

Route::any('nhs-prescriptions/copy/{uuid}', [
    'as' => 'nhs-prescriptions-copy',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\PrescriptionsController@copy'
]);

Route::post('nhs-prescriptions/save/{uuid}', [
    'as' => 'nhs-prescriptions-save',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\PrescriptionsController@save'
]);


/* Checkout */

Route::get('nhs-prescriptions/data/pending', [
    'as' => 'nhs-prescriptions-data-pending',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\CheckoutController@data_pending_prescriptions'
]);

Route::get('nhs-prescriptions/confirm', [
    'as' => 'nhs-prescriptions-confirm',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\CheckoutController@confirm'
]);

Route::post('nhs-prescriptions/checkout', [
    'as' => 'nhs-prescriptions-checkout',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\CheckoutController@checkout'
]);


/* Admin */

Route::any('admin/nhs-prescriptions/overview', [
    'as' => 'admin-nhs-prescriptions-overview',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\AdminController@overview'
]);

Route::get('admin/nhs/unilexicon/manage', [
    'as' => 'nhs-unilexicon-manage',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\Admin\UnilexiconController@manage'
]);

Route::get('admin/nhs/unilexicon/increase_charges/{id}', [
    'as' => 'nhs-unilexicon-increase-charges',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\Admin\UnilexiconController@increase_charges'
]);

Route::get('admin/nhs/unilexicon/decrease_charges/{id}', [
    'as' => 'nhs-unilexicon-decrease-charges',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\Admin\UnilexiconController@decrease_charges'
]);


/* Read-only */

Route::post('nhs-prescriptions/data/prescription/{prescription_uuid}', [
    'as' => 'nhs-prescriptions-data-prescription',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@data_prescription'
]);

Route::post('nhs-prescriptions/data/member/{prescription_uuid}', [
    'as' => 'nhs-prescriptions-data-member',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@data_member'
]);

Route::get('nhs-prescriptions/doctor-surgeries/search', [
    'as' => 'nhs-prescriptions-surgeries-search',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@getAvailableDoctorSurgeries'
]);

Route::get('nhs-prescriptions/exemption/reasons', [
    'as' => 'nhs-prescriptions-exemption-reasons',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@getAvailableExemptionReasons'
]);

Route::get('nhs-prescriptions/medical/categories', [
    'as' => 'nhs-prescriptions-medical-categories',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@getAvailableMedicalCategories'
]);

Route::any('nhs-prescriptions/medications/search', [
    'as' => 'nhs-prescriptions-medications-search',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@getPrescriptionMedications'
]);

Route::any('nhs-prescriptions/medications/name-is-valid', [
    'as' => 'nhs-prescriptions-data-check-medication-name-is-valid',
    'uses' => 'Mtc\Plugins\NHS\Http\Controllers\DataController@checkMedicationNameIsValid'
]);
