<?php
use Illuminate\Database\Capsule\Manager as Capsule;
use Mtc\Core\Setting;
use \Mtc\Plugins\NewsletterSignup\Classes\Newsletter;

/**
 * The defaults are only set on the first load.
 * After this they are available to amend in site settings.
 */
$data = [
    [
        'key' => 'NEWSLETTER_SIGNUP_INSTALLED',
        'type' => 'bool',
        'value' => 1,
        'module' => 'Newsletter',
        'description' => 'Enable/Disable Newsletter Signup plugin',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'POPUP',
        'type' => 'bool',
        'value' => 0,
        'module' => 'Newsletter',
        'description' => 'Enable/Disable Newsletter Signup popup overlay',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'POPUP_DELAY',
        'type' => 'int',
        'value' => 0,
        'module' => 'Newsletter',
        'description' => 'In milliseconds set delay after page load to show popup',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'POPUP_AFTER_PAGE_VISITS',
        'type' => 'int',
        'value' => 1,
        'module' => 'Newsletter',
        'description' => 'Set to how many pages user must view before being shown the popup',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'POPUP_SHOW_ONLY_ONCE',
        'type' => 'bool',
        'value' => 0,
        'module' => 'Newsletter',
        'description' => 'Set to true to prevent popup from showing for 365days',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'USE_NAME_FIELDS',
        'type' => 'bool',
        'value' => 1,
        'module' => 'Newsletter',
        'description' => 'Set to true to add first name and surname fields to form template',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'NEWSLETTER_DRIVER',
        'type' => 'string',
        'value' => 'default',
        'module' => 'Newsletter',
        'description' => "'default' or 'campaign_monitor' or 'mailchimp' for newsletter driver",
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'NEWSLETTER_CM_API_KEY',
        'type' => 'string',
        'value' => '',
        'module' => 'Newsletter',
        'description' => 'Campaign Monitor API Key',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'NEWSLETTER_CM_LIST_ID',
        'type' => 'string',
        'value' => '',
        'module' => 'Newsletter',
        'description' => 'ID of the list within Campaign Monitor',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'NEWSLETTER_MAILCHIMP_API_KEY',
        'type' => 'string',
        'value' => '',
        'module' => 'Newsletter',
        'description' => 'Mailchimp API Key',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'NEWSLETTER_MAILCHIMP_LIST_ID',
        'type' => 'string',
        'value' => '',
        'module' => 'Newsletter',
        'description' => 'ID of the list within Mailchimp',
        'created_at' => new DateTime(),
    ]
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::Insert($data);

/**
 * Add Tables to database
 */

// Check if the table exists. If it doesn't, build it.
//$schema = Capsule::connection()->getSchemaBuilder();
//
//if ($schema->hasTable('emails_lists') === false) {
//    // Build the table
//    $schema->create('emails_lists', function ($table) {
//        $table->increments('id');
//        $table->string('name');
//        $table->timestamps();
//        $table->index('id');
//    });
//}
//
//if ($schema->hasTable('emails_lists_mails') === false) {
//    // Build the `emails_lists_mails` table
//    $schema->create('emails_lists_mails', function ($table) {
//        $table->increments('id');
//        $table->integer('list_id')->unsigned();
//        $table->string('email');
//        $table->string('firstname');
//        $table->string('surname');
//        $table->timestamps();
//        $table->index('id');
//    });
//}
//
//if ($schema->hasTable('emails_double_optin') === false) {
//    // Build the `emails_double_optin` table
//    $schema->create('emails_double_optin', function ($table) {
//        $table->increments('id');
//        $table->string('email');
//        $table->string('firstname');
//        $table->string('surname');
//        $table->timestamps();
//        $table->index('id');
//    });
//}
//
//if (!Capsule::table('emails_lists')->where('name', Newsletter::$newsletter_list_name)->count()) {
//// Create the newsletter email list
//    Capsule::table('emails_lists')->insert([
//        'name' => Newsletter::$newsletter_list_name
//    ]);
//}
//
//// Throw in necessary RewriteRule
//$rewrite_rule = "RewriteEngine On\n\nRewriteRule ^newsletter(/)?$ /plugins/NewsletterSignup/ [QSA,L]\n";
//$htaccess = file_get_contents(SITE_PATH . '/.htaccess');
//if (strpos($htaccess, 'NewsletterSignup') === false) {
//    $htaccess = str_replace('RewriteEngine on', $rewrite_rule, $htaccess);
//    file_put_contents(SITE_PATH . '/.htaccess', $htaccess);
//}