<?php

use Mtc\Plugins\RyftPay\Classes\RyftPay;
use Twig\TwigFunction;
use Illuminate\Support\Facades\Event;

$twig->addFunction(new TwigFunction('ryftpay_assets', function () use ($twig) {
    if (!config('ryftpay.enabled')) {
        return;
    }

    echo $twig->render('RyftPay/assets.twig', []);
}));

if (config('ryftpay.enabled')) {
    Event::listen('Order/initializePayment', '\\' . RyftPay::class . '@initializePayment');
    Event::listen('Order@updateStatus', '\\' . RyftPay::class . '@orderStatusUpdateListener');

    Event::listen('refunds.get_refund_methods', function () {
        return [
            'id' => 'ryftpay',
            'name' => 'Ryftpay Refund',
            'callback' => '\\' . Ryftpay::class . '::handleRefund'
        ];
    });
}