<?php
/**
 * Seo Schema Installer
 *
 * Adds required settings to site as they are pushed live with settings.db.php
 * Rest of the changes are populated through migrations
 *
 * Shop extension functionality to add in manageable item specific seo schema.
 * This requires shop to be present
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Mtc\Core\Setting;

$data = [
    [
        'key' => 'SEO_ITEM_SCHEMA_ENABLED',
        'type' => 'bool',
        'value' => true,
        'module' => 'Seo Schema',
        'description' => 'Enable / Disable Item Seo Schema plugin',
        'created_at' => new \DateTime(),
    ]
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::Insert($data);

$source = __DIR__ . '/20171017-1-AddSeoSchemaTable.php';
$destination = SITE_PATH . '/migrations//20171017-1-AddSeoSchemaTable.php';

// Copy the migration file over to migrations dir
if (!file_exists($destination)) {
    copy($source, $destination);

    exec('/usr/local/bin/php ' . SITE_PATH . '/migrations.php');
}