<?php
/**
 * Shared Buttons Admin
 *
 * Provide an admin panel to administer sharing icons
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

$path = '../../../';
$page_meta['title'] = 'Social Sharing Icons';

require_once $path . 'core/includes/header.inc.php';

require_once __DIR__ . '/install/install.php';

use \Mtc\Plugins\ShareButtons\Classes\ShareButtons;

if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'update') {

    if (isset($_REQUEST['social_button_class'])) {

        $file_keys = array_keys($_REQUEST['social_button_class']);

        foreach ($file_keys as $update_id) {

            $update_button = ShareButtons::find($update_id);

            $request_hide = false;

            if (isset($_REQUEST['hide'][$update_id]) && $_REQUEST['hide'][$update_id] == 'on') {
                $request_hide = true;
            }

            $update_array = [
                'social_button_link' => $_REQUEST['social_button_link'][$update_id],
                'social_button_class' => $_REQUEST['social_button_class'][$update_id],
                'social_button_text' => $_REQUEST['social_button_text'][$update_id],
                'social_button_icon' => $_REQUEST['social_button_icon'][$update_id],
                'hide' => $request_hide
            ];

            $update_button->fill($update_array);

            $update_button->save();
        }

    }

} elseif ( !empty($_REQUEST['action']) && $_REQUEST['action'] == 'addnew') {
    ShareButtons::create($_REQUEST);
} elseif ( !empty($_REQUEST['action']) && $_REQUEST['action'] == 'delete' ) {
    ShareButtons::find($_REQUEST['delete_id'])->delete();
}

$share_buttons = ShareButtons::orderBy('order', 'asc')->get();

require_once $path . 'core/admin/templates/adminheader.html.php';

?>

<link rel="stylesheet" href="css/admin.css">

<ul class="breadcrumbs el">
    <li><a href="/admin/">Admin</a> /</li>
    <li class="end"><?= $page_meta['title'] ?></li>
</ul>

<h1><?= $page_meta['title'] ?></h1>
<form action="" method="post" class="style">
 <fieldset>
     <h1>
        <a href="#" class="show el">
            Add More <i class="fa fa-caret-down"></i>
        </a>
    </h1>
    <div class="row">
        <label for="name">Name</label>
        <input type="text" name="social_network" />
    </div>
    <div class="row">
        <label for="class">Link</label>
        <input type="text" name="social_button_link" />
    </div>
    <div class="row">
        <label for="class">Class</label>
        <input type="text" name="social_button_class" />
    </div>
    <div class="row">
        <label for="class">Text</label>
        <input type="text" name="social_button_text" />
    </div>
    <div class="row">
        <label for="class">Icon</label>
        <input type="text" name="social_button_icon" />
    </div>
    <div class="row">
        <label for="hide">Hide</label>
        <input type="hidden" name="hide" value="0" />
        <input type="checkbox" name="hide" value="1"/>
    </div>
    <div class="row"><br>
        <input type="submit" value="Add New"/>
        <input type="hidden" name="action" value="addnew" />
    </div>
</fieldset>
</form>

<form id="share_buttons_sortable" action="" method="post" class="style">

    <?php
    foreach ($share_buttons as $share_button) {
        ?>
        <fieldset id="rorder-<?= $share_button->id ?>">

            <h1>
                <i class="fa fa-arrows"></i>
                <a href="#" class="share_buttons_show el">
                    <?= clean_page($share_button->social_network) ?> <i class="fa fa-caret-down"></i>
                </a>
            </h1>

            <div class="row">
                <label for="socialButtonLink<?= $share_button->id ?>">Link</label>
                <input type="text"
                    name="social_button_link[<?= $share_button->id ?>]"
                    id="socialButtonLink<?= $share_button->id ?>"
                    value="<?= clean_page($share_button->social_button_link) ?>"
                />
            </div>

            <div class="row">
                <label for="socialButtonClass<?= $share_button->id ?>">Class</label>
                <input type="text"
                    name="social_button_class[<?= $share_button->id ?>]"
                    id="socialButtonClass<?= $share_button->id ?>"
                    value="<?= clean_page($share_button->social_button_class) ?>"
                />
            </div>

            <div class="row">
                <label for="socialButtonText<?= $share_button->id ?>">Text</label>
                <input type="text"
                    name="social_button_text[<?= $share_button->id ?>]"
                    id="socialButtonText<?= $share_button->id ?>"
                    value="<?= clean_page($share_button->social_button_text) ?>"
                />
            </div>

            <div class="row">
                <label for="socialButtonIcon<?= $share_button->id ?>">Icon</label>
                <input type="text"
                    name="social_button_icon[<?= $share_button->id ?>]"
                    id="socialButtonIcon<?= $share_button->id ?>"
                    value="<?= clean_page($share_button->social_button_icon) ?>"
                />
            </div>

            <div class="row">
                <label for="hide<?= $share_button->id ?>">Hide</label>
                <input type="checkbox"
                    name="hide[<?= $share_button->id ?>]"
                    id="hide<?= $share_button->id ?>"
                    <?php
                    if ($share_button->hide == true) {
                        echo ' checked';
                    }
                    ?>
                />
            </div>

            <div class="row">
               <label for="delete">Delete</label>
                <a class="alert error"
                    title="Are you sure you want to delete this icon?"
                    href="index.php?&action=delete&delete_id=<?= $share_button->id; ?>"
                >
                    <i class="fa fa-remove"></i>
                </a>
            </div>

    </fieldset>

    <?php
}
?>

<fieldset class="show">
    <input type="submit" value="Update Share Icons"/>
    <input type="hidden" name="action" value="update" />
</fieldset>

</form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
