<?php
/**
 * Site Menu Listing page
 *
 * @category Plugins
 * @package  Mtc_Site_Menu
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\SiteMenu\Classes;

use Illuminate\Support\Facades\Event;
use MtcPharmacy\Multisite\Classes\MultisiteManager;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
require_once dirname(__DIR__) . '/includes/install.php';

init_request_values([
    'menu' => null,
]);

$page['title'] = 'Manage Site Menu';

// ------------------------ POSTBACK --------------------------

// Delete a menu entry
if (!empty($_REQUEST['action'])
    && !empty($_REQUEST['delete_id'])
    && $_REQUEST['action'] === 'delete'
    && $_REQUEST['delete_id'] > 0) {
    SiteMenu::destroy($_REQUEST['delete_id']);
}

// Change published status
if (!empty($_REQUEST['action'])
    && !empty($_REQUEST['menu_id'])
    && $_REQUEST['action'] === 'change_published') {
    $menu = SiteMenu::query()->find($_REQUEST['menu_id']);
    if (isset($_REQUEST['value'])
        && in_array($_REQUEST['value'], [0, 1])) {
        $menu->published = (int) $_REQUEST['value'];
        $menu->save();
    }
}

if (!empty($_REQUEST['id'])) {
    $current_menu = SiteMenu::find($_REQUEST['id']);
    $menu_items   = $current_menu->getSubMenu(true);
} elseif (!empty($_REQUEST['menu_id'])) {
    $current_menu = $menu->parentMenu ? $menu->parentMenu : new SiteMenu;
    $menu_items   = $current_menu->getSubMenu(true);
} else {
    $current_menu = SiteMenu::find(1);
    $menu_items   = $current_menu->getSubMenu(true);
}

if ($current_menu->parentMenu) {
    $root_menu = $current_menu->getAncestors()->last();
} else {
    $root_menu = $current_menu;
}

$mm = new MultisiteManager($root_menu);
$mm->ensureTheCorrectAdminPageLoaded();


// --------------------- END OF POSTBACK ----------------------


require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<?php Event::dispatch('AdminBeforeBreadcrumbs', [ $root_menu->exists ? $root_menu : null ]); ?>

<ul class="breadcrumbs el">
    <?php
    require 'breadcrumbs.php';
    ?>
</ul>
<h1>Manage Site Menu</h1>

<?php
require 'tabnav.php';


if (!empty($_REQUEST['action']) && $_REQUEST['action'] == 'change_published' && isset($_REQUEST['value'])) {
    $message = 'Menu "' . $menu->name . '" ' . ($_REQUEST['value'] == 1 ? 'Activated' : 'Deactivated');
    echo showmsg($message, 'success', $path);
}
if (count($menu_items) > 0) {
    ?>
    <table id="manage-site-menus" class="manage-items">
        <tr>
            <?php if (!empty($current_menu->id)) { ?>
            <th class="center">Order</th>
            <?php } ?>
            <th class="center">Menu ID</th>
            <th>Name</th>
            <th>Sub Items</th>
            <th class="center">Active</th>
            <th class="center">Edit</th>
            <th class="center">Delete</th>
        </tr>
        <tbody class="tabular<?= !empty($current_menu->id) ? ' ui-sortable' : ''; ?>">

            <?php
            foreach ($menu_items as $menu) {
                ?>
                <tr id="rorder-<?= clean_page($menu->id) ?>">
                    <?php if (!empty($current_menu->id)) { ?>
                    <td class="center">
                        <i class="fa fa-arrows"></i>
                    </td>
                    <?php } ?>
                    <td class="center">
                        <a href="edit.php?id=<?= clean_page($menu->id); ?>">
                            <?= clean_page($menu->id); ?>
                        </a>
                    </td>
                    <td>
                        <a href="edit.php?id=<?= clean_page($menu->id); ?>">
                            <?= clean_page($menu->name); ?>
                        </a>
                    </td>
                    <td>
                        <a href="index.php?id=<?= clean_page($menu->id); ?>" >
                            View sub-items (<?= $menu->directChildrenCount(); ?>)
                        </a>

                        <br />

                        <?php if ($menu->directChildrenCount()): ?>
                            <?php $number_of_subitems_to_display = 6; ?>
                            <ul>
                                <?php foreach ($menu->children->take($number_of_subitems_to_display) as $sub_item): ?>
                                    <li>&nbsp;- <?= $sub_item->name ?></li>
                                <?php endforeach ?>

                                <?php if ($menu->directChildrenCount() > $number_of_subitems_to_display): ?>
                                    <li>&nbsp;- (more)</li>
                                <?php endif ?>
                            </ul>
                        <?php else: ?>
                            &nbsp;&nbsp;&nbsp;(empty)
                        <?php endif ?>

                    </td>
                    <td class="center">
                        <?php
                        if ($menu->published) {
                            $params = [
                                'menu'=> $_REQUEST['menu'],
                                'menu_id' => clean_page($menu->id),
                                'action' => 'change_published',
                                'value' => 0,
                            ];
                            ?>
                            <a href="<?= \Util::add_query_arg($params, 'index.php') ?>"
                                class="alert error"
                                title="Are you sure you want to unpublish this menu?">
                                <i class="fa fa-check"></i>
                            </a>
                            <?php
                        } else {
                            $params = [
                                'menu'=> $_REQUEST['menu'],
                                'menu_id' => clean_page($menu->id),
                                'action' => 'change_published',
                                'value' => 1,
                            ];
                            ?>
                            <a href="<?= \Util::add_query_arg($params, 'index.php') ?>">
                                <i class="fa fa-square-o"></i>
                            </a>
                            <?php
                        }
                        ?>
                    </td>
                    <td class="center">
                        <a href="edit.php?id=<?= clean_page($menu->id); ?>" class="edit">
                            <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                    <td class="center">
                        <?php
                            $params = [
                                'delete_id' => clean_page($menu->id),
                                'action' => 'delete',
                                'id' => filter_input(INPUT_GET, 'id')
                            ];
                        ?>
                        <a href="<?= \Util::add_query_arg($params, 'index.php') ?>"
                           class="alert error"
                           title="Are you sure you want to delete this menu item?">
                            <i class="fa fa-remove"></i>
                        </a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
    <input type="hidden" id="orderbytable" value="site_menu" />
    <input type="hidden" id="orderbyfield" value="order" />
    <input type="hidden" id="orderbymenu" value="<?= $current_menu->name; ?>" />
<?php
} else {
    ?>
    <p>There are currently no menu items added</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
