<?php
/**
 * Static Block Sizes Class
 *
 * This code defines the sizes of banner images used within static blocks
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\StaticBlocks\Classes;
use Illuminate\Database\Eloquent\Model;

/**
 * Static Block Sizes Class. Eloquent model that defines image block sizes.
 * Stores uploadSizes function that returns all sizes in format of current
 * image_folders used for display and upload/resize througout site.
 *
 * @category Plugins
 * @package  Mtc_Static_Blocks
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
Class StaticBlockSizes extends Model
{
    /**
     * @var String Classes associated table
     */
    protected $table = 'static_blocks_sizes';

    /**
     * @var boolean Disables use of eloquent timestamps
     */
    public $timestamps = false;

    /**
     * StaticBlockSizes::uploadSizes()
     *
     * Retrieve available sizes in format of image_folders structure
     *
     * @access public
     * @return array $result list of sizes in format of image_folders structure
     */
    public static function uploadSizes()
    {
        $sizes = self::all();
        $result = [];
        foreach ($sizes as $size) {
            $result[$size->name] = [
                    'path' => 'uploads/images/static_blocks/' . $size->name,
                    'width' => $size->width,
                    'height' => $size->height,
                    'forced' => $size->forced,
                    'crop' => $size->crop,

            ];
        }
        return $result;
    }

    /**
     * StaticBlockSizes::getPaths()
     *
     * Retrieve paths for static block image sizes
     *
     * @access public
     * @return array $data list of size paths
     */
    public static function getPaths()
    {
        return self::all()
            ->keyBy('id')
            ->map(function($size) {
                return '/uploads/images/static_blocks/' . $size->name;
            })->toArray();
    }

}