<?php
/**
 * Loader file for Static Blocks plugin
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

// The defaults are only set on the first load.
// After this they are available to amend in site settings.
if (!defined('STATIC_BLOCKS_ENABLED')) {
    include_once __DIR__ . '/admin/includes/install.php';
}

// Add hooks
HooksAdapter::add_action(
    'call_static_block',
    '\Mtc\Plugins\StaticBlocks\Classes\StaticBlockParser::getBlock',
    10, // Priority - 10 is default
    2, // Accepted args from hook
    [ $twig ] // forced args passed to hook
);
