<?php

namespace MtcPharmacy\Bundles\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Item as ShopItem;
use Mtc\Shop\Item\Size as ShopItemSize;
use Mtc\Shop\Category;


class BundleTypeItem extends Model
{
    protected $table = 'bundle_types_items';

    protected $fillable = [];

    protected $appends = [
        'display_name',
        'display_price',
        'product_page_url',
    ];


    public function bundle_type()
    {
        return $this->belongsTo(BundleType::class, 'bundle_type_id');
    }

    public function shop_item()
    {
        return $this->belongsTo(ShopItem::class, 'shop_item_id');
    }

    public function shop_item_size()
    {
        return $this->belongsTo(ShopItemSize::class, 'shop_item_size_id');
    }


    public static function getAllowedCategories()
    {
        $allowed_categories = [];

        $temp_categories = Category::query()
            ->with('parent')
            ->orderBy('name')
            ->get()
        ;

        foreach ($temp_categories as $temp_category) {
            $cat_label = $temp_category->name;

            if ($temp_category->parent) {
                $cat_label .= " \\\\ {$temp_category->parent->name}";
            }
            $allowed_categories[$temp_category->id] = $cat_label;
        }


        return $allowed_categories;
    }


    public function getAdminUrl()
    {
        $url = $this->shop_item->name;

        if ($this->shop_item_size) {
            $url = " // {$this->shop_item_size->size}";
        }

        return $url;
    }


    public function getDisplayNameAttribute()
    {
        $name = $this->shop_item->name;

        if ($this->shop_item_size) {
            $name .= " // {$this->shop_item_size->size}";
        }

        return $name;
    }


    public function getDisplayPriceAttribute()
    {
        $display_price = 999;

        if ($this->shop_item_size) {
            $display_price = $this->shop_item_size->price;
        } else {
            $display_price = $this->shop_item->price;
        }

        return $display_price;
    }


    public function getProductPageUrlAttribute()
    {
        $url = 'abc';

        $url = $this->shop_item->legacy()->url;

        return $url;
    }
}
