<?php

namespace MtcPharmacy\Bundles\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use MtcPharmacy\Bundles\Classes\BundleType;
use MtcPharmacy\Bundles\Classes\BundleTypeItem;
use Mtc\Shop\Item as ShopItem;
use Mtc\Shop\Item\Size as ShopItemSize;
use MtcPharmacy\Subscriptions\Classes\SubscriptionItem;
use Mtc\Shop\Category;
use Illuminate\Support\Facades\Session;


class BundleTypesController extends \App\Http\Controllers\Controller
{

    public function manage()
    {
        $bundle_types = BundleType::all();

        return template('admin/bundle_types_manage.twig', [
            'selected_tab' => 'manage',
            'title' => 'Bundle Types',
            'bundle_types' => $bundle_types,
        ]);
    }


    public function update(int $type_id, Request $request)
    {
        $bundle_type = BundleType::findOrFail($type_id);

        if ($request->input('button_pressed') == 'add_single_item') {
            list($shop_item_id, $shop_item_size_id) = explode(':', $request->input('item_id'));

            $shop_item = ShopItem::findOrFail($shop_item_id);
            $shop_item_size = ShopItemSize::find($shop_item_size_id);

            $bundle_type->addItem($shop_item, $shop_item_size);
        }

        if ($request->input('button_pressed') == 'add_category_items') {
            $category_id = $request->input('category_id');
            $category = Category::findOrFail($category_id);

            foreach ($category->items as $category_item) {
                $bundle_type->addItem($category_item);
            }
        }

        if ($request->input('button_pressed') == 'save') {
            $bundle_type->fill($request->input());
            $bundle_type->save();
            Session::flash('success_message', [ 'type' => 'success', 'content' => 'Saved.' ]);
        }

        return redirect()->back();
    }


    public function edit(int $type_id, Request $request)
    {
        $bundle_type = BundleType::findOrFail($type_id);

        $allowed_items = SubscriptionItem::getAllowedItems();
        $allowed_categories = BundleTypeItem::getAllowedCategories();

        $allowed_forms = \Mtc\Shop\Assessment\Form::get()
            ->pluck('name', 'id')
            ->sortBy('name')
        ;

        $messages = $this->getFormMessages();

        return template('admin/bundle_type_edit.twig', [
            'selected_tab' => 'edit',
            'title' => 'Bundle Type Edit',
            'bundle_type' => $bundle_type,
            'allowed_forms' => $allowed_forms,
            'allowed_items' => $allowed_items,
            'allowed_categories' => $allowed_categories,
            'messages' => $messages,
        ]);
    }


    private function getFormMessages()
    {
        $messages = [];

        if ($success_message = Session::pull('success_message')) {
            $messages[] = $success_message;
        }

        if ($form_errors = Session::pull('form_errors')) {
            $messages[] = ['type' => 'error', 'content' => 'Something went wrong!'];
        }

        return $messages;
    }


    public function delete_item(int $bundle_type_item_id, Request $request)
    {
        $bundle_type_item = BundleTypeItem::findOrFail($bundle_type_item_id);

        $bundle_type_item->delete();

        return redirect()->back();
    }

}
