<?php

namespace MtcPharmacy\Multisite\Http\Controllers\Admin;

use Illuminate\Http\Request;
use MtcPharmacy\Multisite\Classes\MultisiteBaseEntity;
use MtcPharmacy\Multisite\Classes\MultisiteConstants;


class MultisiteController extends \App\Http\Controllers\Controller
{

    public function switch_mode(Request $request)
    {
        $base_entity = MultisiteBaseEntity::find((int)request()->input('base_entity_id'));

        $base_entity->mode = $request->input('target_mode');
        $base_entity->save();

        $redirect_url = '';
        if ($base_entity->mode == MultisiteConstants::MODE_MULTI_SITE) {
            $base_entity->ensureCustomEntitiesExist();

            $custom_entities = $base_entity->custom_entities;
            if ($custom_entities) {
                $redirect_url = $custom_entities->first()->getConcreteEntity()->getAdminUrl();
            }
        } else {
            $redirect_url = $base_entity->getConcreteEntity()->getAdminUrl();
        }

        return redirect($redirect_url);
    }

}




