# Subscriptions


## How to install

Add the following service provider class to `/config/app.php`:
`\MtcPharmacy\Subscriptions\SubscriptionsServiceProvider::class` (for routes & migrations to work).

Run migrations (e.g. `php artisan migrate`)


### Issues

To discover the templates you might need to edit `/core/includes/header.inc.php`:

```php
$view_paths = Config::get('view.paths');

foreach ($view_paths as $view_path) {
    $template_paths[] = $view_path;
}
```

Create a symlink to the subscription preferences component:

`./core/admin/js/subscription_preferences.vue.js -> ../../../plugins/mtc_pharmacy_subscriptions/src/assets/js/components/subscription_preferences.vue.js`


You might need to update some of the admin css and templates:
`core/templates/includes/input_fields/...`
`core/admin/css/mtc_admin_style.less`


You might need to include DataTable.js: (core/templates/admin/meta.twig)

`<link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.25/css/jquery.dataTables.min.css" />`
`<script type="text/javascript" src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>`


### How to use

Admin subscription-preferences widget:
Add `<?= SubscriptionsHelper::renderItemForm($item_eloquent) ?>` to `shop/admin/products/item.php`

