<?php

namespace MtcPharmacy\Subscriptions\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;
use MtcPharmacy\Subscriptions\Classes\Subscription;


class SubscriptionsController extends BaseController
{

    public function set_paused($subscription_id, Request $request)
    {
        $subscription = Subscription::findOrFail($subscription_id);

        if ($subscription) {
            $subscription->authoriseAccessByCurrentUser();
        }

        if ($subscription->isActive()) {
            $subscription->setPaused();
        }

        return redirect()->back();
    }


    public function set_active($subscription_id, Request $request)
    {
        $subscription = Subscription::findOrFail($subscription_id);

        if ($subscription) {
            $subscription->authoriseAccessByCurrentUser();
        }

        if ($subscription->isPaused()) {
            $subscription->setActive();
        }

        return redirect()->back();
    }


    public function set_cancelled($subscription_id, Request $request)
    {
        $subscription = Subscription::findOrFail($subscription_id);

        if ($subscription) {
            $subscription->authoriseAccessByCurrentUser();
        }

        $subscription->setCancelled();

        return redirect()->back();
    }

}

