Vue.component('print-labels-manager', {

    props: [
        "orderItem",
        "groups",
    ],


    data: function() {
        return {
            dataGroups: [],
        };
    },


    created: function() {

        this.groups.forEach((group) => {
            this.addGroup( group.name );
        })

    },


    computed: {

        maxQty: function() {
            return this.orderItem.quantity;
        },


        currentTotalQty: function() {
            let total_qty = 0;

            this.dataGroups.forEach((group) => {
                total_qty += parseInt(group.qty);
            });

            return total_qty;
        },

    },


    methods: {

        addGroup: function(group_name) {
            let temp_group = {
                name: group_name || "Group " + (new Date()).getTime(),
                qty: 0,
                labels: [],
            };

            this.dataGroups.push(temp_group);
            this.distributeGroupQty();

            this.addLabel(temp_group);
        },


        distributeGroupQty: function() {
            const qty_per_group = Math.ceil(this.maxQty / this.dataGroups.length);

            let remaining_qty = this.maxQty;
            this.dataGroups.forEach((group) => {
                if (remaining_qty >= qty_per_group) {
                    group.qty = qty_per_group;
                } else {
                    group.qty = remaining_qty;
                }
                remaining_qty -= group.qty;
            });

            this.dataGroups.forEach((group) => {
                this.distributeLabelQty(group);
            });
        },


        addLabel: function(group) {
            group.labels.push({ qty: 0 });

            this.distributeLabelQty(group);
        },


        distributeLabelQty: function(group) {
            const qty_per_label = Math.ceil(group.qty / group.labels.length);

            let remaining_qty = group.qty;
            group.labels.forEach((label) => {
                if (remaining_qty >= qty_per_label) {
                    label.qty = qty_per_label;
                } else {
                    label.qty = remaining_qty;
                }
                remaining_qty -= label.qty;
            });
        },


        deleteLabel: function(labelIndex, group) {
            group.labels.splice(labelIndex, 1);

            this.distributeLabelQty(group);
        },


        getCurrentGroupTotal: function(group) {
            let total_qty = 0;

            group.labels.forEach((label) => {
                total_qty += parseInt(label.qty);
            });

            return total_qty;
        },


        saveData: function() {
            var that = this;

            let submit_data = {
                data: this.data,
            };

            this.isBusy = true;

            fetch(this.saveDataUrl, {
                method: 'POST',
                body: JSON.stringify(submit_data),
                headers: {
                    'Content-Type': 'application/json'
                },
            })
            .then(response => response.json())
            .then(data => {
                that.isBusy = false;
            });
        },

    },

    template: `
        <section>

            <div>
                <h4 v-text="orderItem.item_name"></h4>
                <print-labels-manager-total
                    :current-value="currentTotalQty"
                    :max-value="maxQty"
                ></print-labels-manager-total>
            </div>

            <table border="1" cellpadding="4">
                <tr v-for="group in dataGroups">
                    <td>
                        <span v-text="group.name"></span>

                        <br />

                        <input
                            type="number"
                            v-model="group.qty"
                            @change="distributeLabelQty(group)"
                        />

                    </td>

                    <td>
                        <print-labels-manager-total
                            :current-value="getCurrentGroupTotal(group)"
                            :max-value="group.qty"
                        ></print-labels-manager-total>

                        <table border="1" cellpadding="4">
                            <tr v-for="(label, l) in group.labels">
                                <td>
                                    <span v-text="'Label ' + l"></span>
                                </td>
                                <td>
                                    <input
                                        type="number"
                                        v-model="label.qty"
                                        :name="'labels[' + orderItem.id + '][' + group.name + '][]'"
                                    />
                                </td>
                                <td>
                                    <a href="" class="error"
                                        @click.prevent="deleteLabel(l, group)"
                                    >
                                        <i class="fa fa-remove" ></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3">
                                    <button class="btn" @click.prevent="addLabel(group)">
                                        <i class="fa fa-plus-circle btn-fa-icon" ></i>
                                        LABEL
                                    </button>
                                </td>
                            </tr>
                        </table>

                    </td>
                </tr>

                <tr v-if="false">
                    <td colspan="2">
                        <button class="btn" @click.prevent="addGroup('')">
                            <i class="fa fa-plus-circle btn-fa-icon" ></i>
                            GROUP
                        </button>
                    </td>
                </tr>

            </table>

        </section>
    `,

});
