<?php

use Mtc\Modules\DoctorSurgery\Classes\DoctorSurgery;
use Mtc\Shop\Assessment\Answer;

$assessment = Mtc\Shop\Assessment\Assessment::find($assessment_id);

if (! $assessment) {
    echo '<p>No assessment for this item.</p>';
    return;
}

$do_highlight_recommended_qty = false;
if (
    $order_item->recommended_quantity &&
    $order_item->recommended_quantity != $order_item->quantity
) {
    $do_highlight_recommended_qty = true;
}

?>

<tr>
    <th colspan="4">
        <h3>NAME: <?= $assessment->customer_name ?: '-' ?></h3>
        <h5>DOB: <?= $assessment->customer_dob ?: '-' ?></h5>
        <h5>
            <span class="<?= $do_highlight_recommended_qty ? 'error' : '' ?>" style="padding-left: 0 !important;">
                Recommended quantity:
                <?= $order_item->recommended_quantity ?: '-' ?>
            </span>
        </h5>
    </th>
</tr>
<tr>
    <th style="width: 45%;">Question</th>
    <th style="width: 45%">Answer</th>
    <th style="width: 5%">Changes</th>
    <th style="width: 5%"></th>
</tr>

<?php

if ($assessment) {

    $answers = $assessment
        ->answers()
        ->where('answer', '!=', '')
        ->where('question_id', '!=', 0)
        ->orderBy('id')
        ->get();

    /** @var Answer $answer */
    foreach ($answers as $answer) {
        $answer->getDetails();
        echo template('admin/assessments/assessmentAnswer.twig', [
            'answer' => $answer,
        ]);
    }
} else {
    $order_item_meta = \Mtc\Shop\Order\Item::getMeta($order_item_id, $line['item_id']);
    foreach ($order_item_meta as $meta) {
        echo "<tr><td>{$meta->meta_key}</td><td>{$meta->meta_value}</td><td></td><td></td></tr>";
    }
}
?>

