<?php

use Mtc\Shop\PropertyType;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$page_meta['title'] = 'Manage Item Properties';
$errors = [];

init_request_values([
    'page' => null,
]);

/*
  Delete The Property Type
 */
if ($_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {
    \Mtc\Shop\Property::query()
        ->where('property_type_id', '=', $_REQUEST['delete_id'])
        ->delete();
    PropertyType::query()
        ->where('id', '=', $_REQUEST['delete_id'])
        ->delete();
}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>
<h1>Manage Item Properties</h1>

<?php
include 'tabnav.php';

if (sizeof($errors) > 0) {
    showerrors($errors);
}

$query = PropertyType::query();

$totalnumrows = $query->count();

if ($_REQUEST['page'] == '') {
    $_REQUEST['page'] = 1;
}
$rowsPerPage = 25;
$pageNum = $_REQUEST['page'];
$offset = ($pageNum - 1) * $rowsPerPage;

$propertyTypes = $query->skip($offset)
    ->limit($rowsPerPage)
    ->orderBy('order')
    ->get();

$pagestoshow = 10;

if ($propertyTypes->count() > 0) {
    ?>

    <?php
    if ((sizeof($errors) == 0 && $_REQUEST['action'] == 'update') || $_REQUEST['message'] == 'update' ) {
        echo showmsg("Properties updated", "success", $path);
    } elseif ($_REQUEST['message'] == 'added') {
        echo showmsg("Properties added", "success", $path);
    }
    ?>
    <?php
    if (sizeof($errors) == 0 && $_REQUEST['action'] == 'delete') {
        echo showmsg("Properties removed", "success", $path);
    }
    ?>

    <form action="<?= $_SERVER['PHP_SELF']; ?>" method="post">
        <table class="manage-items">
            <tr>
                <th class="fieldname">Name</th>
                <th class="center">Values</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular ui-sortable">
                <?php
                foreach ($propertyTypes as $propertyType) {
                    $data = $propertyType->toArray();
                    ?>
                    <tr id="rorder-<?= $data['id'] ?>">
                        <td><?= clean_page($data['name']) ?></td>
                        <td class="center"><a href="manage.property_values.php?propertyid=<?= $data['id']; ?>" class="edit picto"><i class="fa fa-eye"></i></a></td>
                        <td class="center"><a href="edit.properties.php?id=<?= $data['id']; ?>" class="edit picto"><i class="fa fa-pencil"></i></a></td>
                        <td class="center"><a href="manage.properties.php?action=delete&delete_id=<?php echo $data['id']; ?>" class="alert error" title="Are you sure you want to delete this property?"><i class="fa fa-times-circle"></i></a></td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
    </form>
    <?php
} else {
    ?>
    <p>No Properties have been created</p>
    <?php
}

include $path . 'core/admin/templates/pagination.php';

require_once $path . 'core/admin/templates/adminfooter.html.php';
