<?php
/**
 * SET OUT ALL POSTAL ZONES IN AN ARRAY
 * THE CHECKOUT ALLOWS USE OF POSTCODE ZONES
 * SET WHETHER EACH ZONE REQUIRES POSTCODE OR COUNTRY VALIDATION
 * TO KEEP ALL SIMILAR I HAVE LEFT ZONES 1-200 FREE FOR COUNTRIES AND 20+ FOR POSTCODE ZONES
 *
 * POSTCODE ZONES CAN BE WRITTEN IN AN ARRAY AS FOLLOWS
 * $zone20 = array(
    'IV' => array(), THIS ALLOWS ALL INVERNESS POSTCODES TO BE USED!
    'HS' => array(),

    OR IF THERE IS A RANGE IN THE POSTCODES ADD A MULTI-DIMENSIONAL ARRAY WHICH ALLOWS YOU TO
    SET AN UPPER AND LOWER LIMIT FOR EACH SECTION

    'AB' => array(array(33, 38), array(44, 56)), //this allows AB33-AB38 and AB44-AB56

 * Single postcode zones are written like below
     'GY' => array(array(1, 1)) //this will only exclud GY1 postcodes!
 */


// Select all from delivery zones
use Mtc\Shop\DeliveryZone;

// init zones array.
$GLOBALS['postal_zones'] = [];
$zone_data = [];

$deliveryZones = DeliveryZone::query()
    ->where('disable', 0)
    ->orderBy('zone')
    ->get();
foreach ($deliveryZones as $deliveryZone) {
    $GLOBALS['postal_zones'][$deliveryZone->zone] = 'country';
    $zone_data[$deliveryZone->zone][] = $deliveryZone;
}

foreach($GLOBALS['postal_zones'] as $zone_number => $zone_type) {

	$zone[$zone_number] = [];

	foreach($zone_data[$zone_number] as $zone_datum) {
		$zone[$zone_number][$zone_datum['country_code']] = $zone_datum['country_name'];
	}

}
