<?php

use Mtc\Shop\Order\Protx;

$path = "../../../";
require $path . 'core/includes/header.inc.php';

unset($_SESSION['order_id']);

if (isset($_REQUEST['crypt']) && !empty($_REQUEST['crypt'])) {
    include $path . 'shop/checkout/sagepay/protx.php';

    $Decoded = decodeAndDecrypt($_REQUEST['crypt'], $EncryptionPassword);
    $values = getToken($Decoded);

    $failed = false;

    if ($values['Status'] == 'OK') {
        $empty_basket = true;
    }
}

// tracking code to render on the order complete page. Each array element to contain a piece
// of code that will be rendered as raw html.
$tracking_code = [];

ob_start();

if (isset($_REQUEST['designeraccess']) && defined('TEST_ORDER')) {
    if ($_REQUEST['designeraccess']) {
        $newbasket = new Order(clean_page(TEST_ORDER));
    } else {
        $failed = true;
    }
} elseif (isset($_SESSION['order_id'])) {
    //get basket if exists
    $newbasket = new Order($_SESSION['order_id']);
} else {
    if ($values['Status'] == 'OK') {

        $vendorTxCode = $values['VendorTxCode'];
        $orderReference = $vendorTxCode;
        if (strpos($vendorTxCode, '-') !== false) {
            $orderReference = strstr($vendorTxCode, '-', true);
        }

        $invoiceid = null;
        $prefixPattern = '/^' . preg_quote(config('site.tnx_prefix'), '/') . '(\d+)$/';
        if (preg_match($prefixPattern, $orderReference, $matches)) {
            $invoiceid = (int)$matches[1];
        }

        if ($invoiceid === null) {
            $failed = true;
        }

        if ($failed !== true) {
            $payment = Protx::query()
                ->where('VPSTxId', $values['VPSTxId'])
                ->first();
            if (empty($payment)) {
                $newbasket = new Order($invoiceid);

                $newbasket->saveProtX($values);
                $newbasket->markPaid();
                if (PPC_TRACKING) {
                    track('sale', $newbasket->getTotalCost(), $newbasket->ref, $newbasket->keywords);
                }
                $newbasket->sendOrderConfirmation();

                $_SESSION['order_id'] = $newbasket->getId();
                $_SESSION['basket_id'] = '';

                if (GOOGLE_ANALYTICS_USERAGENT != '') {
                    $tracking_code[] = $GLOBALS['twig']->render('analytics_js.twig', [
                        'order'    => $newbasket,
                        'settings' => $GLOBALS['settings'],
                    ]);
                }
            } else {
                $newbasket = new Order($payment->order_id);
            }
        }
    } else {
        $failed = true;
    }
}

$page_html = ob_get_clean();

if ($failed === true) {

    $page_meta = [
        'title' => 'Your order has not been processed | ' . config('app.name'),
        'page_title' => 'Order issue',
        'page_sub_title' => 'Your order has not been processed',
    ];

    echo $twig->render('shop/checkout/order_failed.twig', [
        'page_html' => $page_html,
        'page_meta' => $page_meta,
    ]);

} else {

    $page_meta = [
        'title' => 'Your order is now complete | ' . config('app.name'),
        'page_title' => 'Order Complete',
        'page_sub_title' => 'Thank you for shopping online with ' . config('app.name'),
    ];

    echo $twig->render('shop/checkout/order_complete.twig', [
        'page_html' => $page_html,
        'page_meta' => $page_meta,
        'basket_object' => $newbasket,
        'tracking_code' => $tracking_code,
    ]);

}
