function addToBasket(data, element) {
    "use strict";

    data += '&ajax=true';

    element.find('.addedToBasket').stop(true,true).fadeOut('slow', function () {
        element.find('.errorAddingToBasket').stop(true,true).fadeOut('slow', function () {
            element.find('.errorAddingToBasketQuantity').stop(true,true).fadeOut('slow', function () {

                $.ajax({
                    type: 'post',
                    url: '/shop/addtobasket.php',
                    data: data,
                    success: function (response) {
                        if (response.error === 'size') {
                            element.find('.errorAddingToBasket').stop(true,true).fadeIn().delay(2000).fadeOut();
                        } else if (response.error === 'nhs_items') {
                            element.find('.errorAddingToBasketNHS').stop(true,true).fadeIn().delay(2000).fadeOut();
                        } else if (response.error === 'quantity') {
                            element.find('.errorAddingToBasketQuantity').stop(true,true).fadeIn().delay(2000).fadeOut();
                        } else if (response.status === 'ok') {
                            element.find('.addedToBasket').stop(true,true).fadeIn('slow', function () {
                                element.find('.addtobasket input[type=tel]').val(0);
                                element.find('.addtobasket input[type=tel]').change();
                                element.find('.totalWrap .amount').text('0.00');
                            }).delay(2000).fadeOut();
                            window.vue_environment.updateMiniBasket();
                        }
                    }
                });

            });
        });
    });

}

function quickAddToBasket(button) {
    'use strict';

    var all_inputs = button.parents('.quickAddToBasket').find('input[type=tel]'),
        input_value,
        all_empty = 0,
        success_message = button.parents('.quickAddToBasket').find('.addedToBasket'),
        qty_message = button.parents('.quickAddToBasket').find('.errorAddingToBasketQuantity'),
        amount_of_inputs = all_inputs.length,
        data,
        element;

    success_message.fadeOut();
    qty_message.fadeOut();

    if (all_inputs.length > 0) {
        $(all_inputs).each(function () {
            input_value = $.trim($(this).val());

            if (input_value == 0) {
                all_empty++;
            }
        });
    }

    if (all_empty === amount_of_inputs) {
        qty_message.fadeIn().delay(2000).fadeOut();
    } else {
        element = button.parents('.quickAddToBasket');
        data = button.parents('form.addtobasket').serialize();
        data += '&add-bag=true';
        addToBasket(data, element);
    }
}

function calculateQuickAddTotal(quick_add_box) {
    'use strict';

    var total = 0;

    quick_add_box.find('.numberArrows').each(function () {
        total += $(this).val() * $(this).data('price');
    });

    quick_add_box.find('.totalWrap .amount').text(total.toFixed(2));
}

function addArrowsToQty() {
    'use strict';

    if ($('.quickAddToBasket')) {
        $('.numberArrows').mtcNumberArrows({
            up_arrow: '<i class="fa fa-plus" aria-hidden="true"></i>',
            down_arrow: '<i class="fa fa-minus" aria-hidden="true"></i>'
        });
    }
}

function quickAddToBasketInit() {
    'use strict';

    addArrowsToQty();
}

$(document).ready(function () {
    'use strict';

    addArrowsToQty();

    if ($('.quickAddToBasket')) {
        $('body').on('click', '.js_addToBasketButton', function (e) {
            e.preventDefault();
            quickAddToBasket($(this))
        });

        $('body').on('keyup', '.numberArrows', function () {
            calculateQuickAddTotal($(this).parents('.quickAddToBasket'));
        });

        $('body').on('click', '.numberButton', function () {
            calculateQuickAddTotal($(this).parents('.quickAddToBasket'));
        });

        $('body').on('click', '.js_quickAdd', function (e) {
            e.preventDefault();

            var parent = $(this).parents('li');

            parent.addClass('visible');
            parent.parent().find('>li').not(parent).removeClass('visible');
            parent.find('.close').one('click', function () {
                parent.removeClass('visible');
            });
            $('body').one('click', function (e) {
                if (!$(e.target).closest('.quickAddToBasket').length) {
                    parent.removeClass('visible');
                }
            });

        });
    }

});