<?php
/**
 * Created by PhpStorm.
 * User: Efraim
 * Date: 19/09/2017
 * Time: 13:51
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class DeliveryServicesOption extends Model
{
    const RM_DELIVERY = 2;
    const DELIVERY_API = 3;

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;

    protected $guarded = [
        'id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function deliveryMethod()
    {
        return $this->hasMany(\DeliveryMethod::class, 'service_id');
    }
}