<?php

/**
 * Incompatible Medications Model
 *
 * @version 22/07/2020
 * @author Uldis Zvirbulis <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Item;

use Illuminate\Database\Eloquent\Model;

/**
 * Incompatible Medications Model
 *
 * @version 22/07/2020
 * @author Uldis Zvirbulis <martins.fridenbergs@mtcmedia.co.uk>
 */
class IncompatibleMedication extends Model
{
    // Use trait that defines relationship to items
    use BelongsToItem;

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'item_id',
        'medication',
        'level',
        'message',

    ];

}