<?php
/**
 * Item Size Labels.
 * @version 03.04.2019
 */

namespace Mtc\Shop\Item;

use Illuminate\Database\Eloquent\Model;

/**
 * Item Size Labels.
 * @version 03.04.2019
 */
class SizeLabel extends Model
{
    // Use trait that defines relationship to items
    use BelongsToItem;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'item_size_labels';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Define the relationship to Ingredient
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function size()
    {
        return $this->belongsTo(Size::class, 'size_id');
    }
}