<?php
$news_container_page_id = $p->sub_id; // ON NEWS ARTICLE PAGE

$parent_page = new Page();
$parent_page->get($p->sub_id);
$twig->addGlobal('parent_page', $parent_page);

// archive is the same lister but without filter
$lister = Listing::newInstance($news_container_page_id)->run();
$lister->getArchive([
    'base_url' => $parent_page->get_url(),
    'index' => array('Publish Date', 'datetime'), // pass this option if you named the date field something other than "date"
    'display_count' => true, // true by default, adds number of articles in a span tag within the title
    'month_format' => 'F ', // You can pass standard php date formats in to here to have the archive show December 2015, January 2016 etc.
    'enable_year_links' => false // Set ups entire year as filterable link, false by default.
]);
$archive_html = CMSNav::generateMenu(
    $lister->archive,
    [
        'item_container_id_prefix'  => 'myArchiveMenu', // menu name so any ids are unique
        'first_container_class'     => 'accordionMenu js_accordionMenu' // class for first ul
    ]
);
$twig->addGlobal('archive_html', $archive_html);

// Tags
$lister = Listing::newInstance($news_container_page_id)->run();
$lister->getTags([
    'base_url'          => $parent_page->get_url(),
    'index'             => array('Tag', 'varchar'), // pass this option if you named the date field something other than "date"
    'display_count'     => true, // true by default, adds number of articles in a span tag within the title
]);
$tags_html = CMSNav::generateMenu($lister->tags);
$twig->addGlobal('tags_html', $tags_html);

$articles = Listing::newInstance($news_container_page_id)
    ->setOrder([array("Publish Date", "DESC", "datetime")])
    ->run();
$articles->getListing();

for ($i = 0; $i < count($articles->list); $i++) {
    $article = $articles->list[$i];
    if ($p->id ===  $article->id) {
        //if not last assign next
        if (count($articles->list) - 1 > $i) {
            $next_article = $i + 1;
        }
        //if not last assign next
        if ($i > 0) {
            $prev_article = $i - 1;
        }
        break;
    }
}



//$twig->addGlobal('prev_article', $articles->list[$prev_article]);
//$twig->addGlobal('next_article', $articles->list[$next_article]);


$twig->addGlobal('prev_article', false);
$twig->addGlobal('next_article', false);

$page_meta['blog_image'] = $p->pagedata['Image'][0]['value'];

// Find relevant articles
$news_container_page_id = $p->sub_id;

$recommend_count = 6;
$recommended_articles = [];

if (!empty($p->pagedata['Category'])) {
    foreach ($p->pagedata['Category'] as $category) {
        $remainder = $recommend_count - count($recommended_articles);
        if ($remainder === 0) {
            break;
        }
        $news_filter = [];
        $news_filter[] = "pages.id != '" . $p->id . "'";
        $news_filter[] = ["Category", $category['value'], "=", "varchar", "group_check"];
        $articles = Listing::newInstance($news_container_page_id)
            ->setLimit($remainder)
            ->setOrder([["Publish Date", "DESC", "datetime"]])
            ->setFilter($news_filter)
            ->run();
        $articles->getListing();
        $recommended_articles = CmsHelper::mergeArticles($recommended_articles, $articles->list);
    }
}

if (count($recommended_articles) < $recommend_count) {
    $remainder = $recommend_count - count($recommended_articles);
    $news_filter = [];
    $news_filter[] = "pages.id != '" . $p->id . "'";
    $articles = Listing::newInstance($news_container_page_id)
        ->setLimit($remainder)
        ->setOrder([array("Publish Date", "DESC", "datetime")])
        ->setFilter($news_filter)
        ->run();
    $articles->getListing();
    $recommended_articles = CmsHelper::mergeArticles($recommended_articles, $articles->list);
}

$twig->addGlobal('recommended_articles', $recommended_articles);
