# Component Registry Quickstart

## Overview
Test the Component Registry feature to ensure developers can browse, preview, and use Twig components effectively.

## Prerequisites
- Pharmacy system running locally or on development server
- Existing Twig components in `sites/default/templates/includes/`
- Vite build system operational
- No authentication required (public access)

## Quick Validation Steps

### 1. Component Discovery (2 minutes)
1. Navigate to Component Registry main page
2. **Verify**: Component cards displayed in grid layout
3. **Verify**: Each card shows component name and description
4. **Verify**: Components organized by categories (pages, forms, popups, etc.)
5. **Verify**: Page loads within 5 seconds
6. **Count**: Should display available Twig files from includes directory

**Expected Result**: Grid of component cards with auto-generated descriptions

### 2. Component Preview (3 minutes)
1. Click on any component card (e.g., "Newsletter Form")
2. **Verify**: New page opens with component in isolation
3. **Verify**: Page has no header/footer (isolated layout)
4. **Verify**: Component renders with sample data
5. **Verify**: Usage instructions displayed
6. **Verify**: Include code example shown
7. **Verify**: Full CSS and JS assets loaded

**Expected Result**: Isolated component view with complete styling and functionality

### 3. Error Handling (2 minutes)
1. Identify or temporarily create a broken Twig component
2. Navigate to Component Registry
3. **Verify**: Broken component appears in listing
4. Click on broken component card
5. **Verify**: Technical error details displayed
6. **Verify**: Error includes file path and specific error message

**Expected Result**: Clear debugging information for broken components

### 4. Category Organization (2 minutes)
1. Browse through different component categories
2. **Verify**: Components grouped by directory structure
3. **Verify**: Category names derived from directory paths
4. **Verify**: Navigation between categories works smoothly
5. **Count**: Categories should match subdirectory structure in includes/

**Expected Result**: Logical organization matching file system structure

### 5. Usage Documentation (3 minutes)
1. Select a component requiring data variables
2. **Verify**: Required variables clearly documented
3. **Verify**: Optional variables listed
4. **Verify**: Include code example is copy-pasteable
5. **Test**: Copy usage example and verify syntax is correct

**Expected Result**: Complete documentation for component integration

## User Acceptance Scenarios

### Scenario 1: Developer Discovers New Component
**Given** a developer needs a form component
**When** they browse the Component Registry
**Then** they can find form-related components in the "forms" category
**And** see preview of each component's appearance
**And** get exact code to include it in their template

### Scenario 2: Developer Previews Component Behavior
**Given** a component with JavaScript functionality
**When** developer clicks to preview it
**Then** the component displays in isolation with full functionality
**And** all styles and JavaScript behaviors work correctly
**And** usage instructions are clearly visible

### Scenario 3: Developer Encounters Broken Component
**Given** a component with syntax errors exists
**When** developer attempts to preview it
**Then** detailed error information is displayed
**And** error includes file location and specific problem
**And** developer can identify and fix the issue

## Performance Validation

### Load Time Testing
- **Main page**: Must load within 5 seconds
- **Component previews**: Should render promptly with full assets
- **Category switching**: Should be responsive and smooth

### Scale Testing (if applicable)
- Test with current number of components in includes directory
- Verify performance remains acceptable as components are added
- Check category organization scales with directory structure

## Integration Validation

### Existing System Compatibility
- **Verify**: No impact on existing Vite build process
- **Verify**: Existing Vue.js components continue to work
- **Verify**: Current CSS/JS compilation unchanged
- **Verify**: Component Registry integrates with existing navigation

### Asset Loading
- **Verify**: Component previews include full app.css
- **Verify**: Component previews include full app.js
- **Verify**: All component styles render correctly in isolation

## Success Criteria
- [ ] All component discovery tests pass
- [ ] All component preview tests pass
- [ ] Error handling tests pass
- [ ] Category organization tests pass
- [ ] Usage documentation tests pass
- [ ] Performance requirements met (<5 second load time)
- [ ] Integration with existing system verified
- [ ] No regressions in existing functionality

## Troubleshooting Common Issues

### Components Not Displaying
- Check file permissions on `sites/default/templates/includes/`
- Verify file system caching is working
- Check for PHP errors in application logs

### Preview Not Rendering
- Verify Twig environment configuration
- Check for missing sample data
- Review component-specific error messages

### Styling Issues in Preview
- Confirm app.css is loaded in preview pages
- Check for CSS conflicts with isolated layout
- Verify Vite build assets are accessible

## Manual Testing Checklist
- [ ] Browse component registry main page
- [ ] Click multiple component cards
- [ ] Test error display for broken components
- [ ] Verify category navigation
- [ ] Test usage code examples
- [ ] Check performance under load
- [ ] Validate integration with existing system