<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Mtc\Modules\Members\Classes\Auth;

class AccountNotVerified
{
    /**
     * Directs user based on the roles, client access and client status
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // If not logged in, ignore
        if (!$member = Auth::getLoggedInMember()) {
            return $next($request);
        }
        return !empty($member->account_verified) ?
            redirect(route('members-dashboard', [], false)) :
            $next($request);
    }
}
