<?php
/**
 * Script for checking if a slug shall conflcit with another page
 * @author Rihards Siliņš
 * @copyright MTC media Ltd
 */
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

if (empty($_GET['slug'])) {
    ContentManagerPanel::messageAndDie(
        "Missing slug param from slug check request.",
        "HTTP/1.0 400 Bad Request"
    );
}
$slug = $_GET['slug'];

if (empty($_GET['page_id']) || !is_numeric($_GET['page_id'])) {
    ContentManagerPanel::messageAndDie(
        "Missing page_id param from slug check request.",
        "HTTP/1.0 400 Bad Request"
    );
}
$page_id = $_GET['page_id'];

if (!isset($_GET['sub_id']) || !is_numeric($_GET['sub_id'])) {
    ContentManagerPanel::messageAndDie(
        "Missing or malformed sub_id param from slug check request.",
        "HTTP/1.0 400 Bad Request"
    );
}
$sub_id = $_GET['sub_id'];

$filtered_slug = $cm->filterSlug($slug);

$checked_slug = $cm->generateSlug("", $filtered_slug, $page_id, $sub_id);

if ($filtered_slug !== $checked_slug) {
    die("slug conflict");
}

die("no slug conflict");
