<?php
/**
 * The SiteTreeEvent event that fires after fetching the CMS site tree
 *
 * @author Florin Radica <florin.radica@mtcmedia.co.uk>
 * @since 02/06/2017
 */

namespace Mtc\Cms\Events;

/**
 * Class SiteTreeEvent
 *
 * @package Mtc\Cms\Events
 */
class SiteTreeEvent
{
    /**
     * @var array $site_tree The CMS site tree
     */
    public $site_tree;

    /**
     * SiteTreeEvent constructor.
     *
     * @param array $site_tree The CMS site tree passed by reference to allow for direct manipulation
     */
    public function __construct(&$site_tree)
    {
        $this->site_tree = &$site_tree;
    }
}
