function init_tinymce() {

    'use strict';

    $('textarea.cmstinymce, textarea.tinymce, textarea.tinymce_simple_with_image, textarea.tinymce_simple').tinymce({

        content_css : "/core/css/tiny_mce.css",

        // General options
        theme : "modern",

        plugins: [
                    "advlist autolink lists link image charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],

        menubar : false,
        statusbar : false,
        convert_fonts_to_spans : true,
        paste_as_text: true,
        relative_urls : false,
        remove_script_host : false,
        convert_urls : true,
        body_class: "pageContent",
        width: 676,
        height: 250,
        resize: "both",
        selector: 'textarea',
        image_dimensions: false,
        image_advtab: false,
        style_formats: [
            {
                title: "Headers",
                items: [
                    {
                        title: "Header 2",
                        format: "h2"
                    },
                    {
                        title: "Header 3",
                        format: "h3"
                    },
                    {
                        title: "Header 4",
                        format: "h4"
                    },
                    {
                        title: "Header 5",
                        format: "h5"
                    },
                    {
                        title: "Header 6",
                        format: "h6"
                    }
                ]
            },
            {
                title: "Inline",
                items: [
                    {
                        title: "Bold",
                        icon: "bold",
                        format: "bold"
                    },
                    {
                        title: "Italic",
                        icon: "italic",
                        format: "italic"
                    },
                    {
                        title: "Underline",
                        icon: "underline",
                        format: "underline"
                    }
                ]
            },
            {
                title: "Blocks",
                items: [
                    {
                        title: "Paragraph",
                        format: "p"
                    },
                    {
                        title: "Blockquote",
                        format: "blockquote"
                    }
                ]
            }
        ],
        advlist_bullet_styles: 'Default',
        advlist_number_styles: 'Default',
        extended_valid_elements: 'script[type],div[itemscope|itemprop|itemtype],h4[itemprop],meta[itemprop|content],span[itemprop|content]',
        toolbar: "undo redo | styleselect bold italic | alignleft aligncenter alignright alignjustify | bullist numlist | link insertfile image",
        contextmenu: "link image inserttable subscript superscript | cell row column deletetable code",
        file_picker_callback: openFilePicker
    });

    $('textarea.simpletinymce').tinymce({
        content_css : "/core/css/tiny_mce.css",

        // General options
        theme : "modern",

        plugins: [
                    "advlist autolink lists link image charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],

        menubar : false,
        statusbar : false,
        convert_fonts_to_spans : true,
        paste_as_text: true,
        relative_urls : false,
        remove_script_host : false,
        convert_urls : true,
        body_class: "wysiwigContent",
        width: 476,
        height: 150,
        resize: "both",
        image_dimensions: false,
        image_advtab: false,

        style : "float:left",
        advlist_bullet_styles: 'Default',
        advlist_number_styles: 'Default',
        style_formats: [
            {
                title: "Headers",
                items: [
                    {
                        title: "Header 2",
                        format: "h2"
                    },
                    {
                        title: "Header 3",
                        format: "h3"
                    },
                    {
                        title: "Header 4",
                        format: "h4"
                    },
                    {
                        title: "Header 5",
                        format: "h5"
                    },
                    {
                        title: "Header 6",
                        format: "h6"
                    }
                ]
            },
            {
                title: "Inline",
                items: [
                    {
                        title: "Bold",
                        icon: "bold",
                        format: "bold"
                    },
                    {
                        title: "Italic",
                        icon: "italic",
                        format: "italic"
                    },
                    {
                        title: "Underline",
                        icon: "underline",
                        format: "underline"
                    }
                ]
            },
            {
                title: "Blocks",
                items: [
                    {
                        title: "Paragraph",
                        format: "p"
                    },
                    {
                        title: "Blockquote",
                        format: "blockquote"
                    }
                ]
            }
        ],
        toolbar: "styleselect | bold italic | bullist numlist | link unlink",
        contextmenu: "link image inserttable | cell row column deletetable code",
        file_picker_callback: openFilePicker
    });

    $('textarea.linkOnlyTinyMce').tinymce({
        content_css : "/core/css/tiny_mce.css",

        // General options
        theme : "modern",

        plugins: [
                    "advlist autolink lists link image charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],

        menubar : false,
        statusbar : false,
        convert_fonts_to_spans : true,
        paste_as_text: true,
        relative_urls : false,
        remove_script_host : false,
        convert_urls : true,
        body_class: "wysiwigContent",
        width: 476,
        height: 150,
        resize: "both",
        image_dimensions: false,
        image_advtab: false,

        style : "float:left",

        toolbar: "link unlink",
        contextmenu: "link | code",
        file_picker_callback: openFilePicker
    });

}
