<?php

namespace Database\Factories;

use App\MemberInfo;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Mtc\Shop\Order;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class OrderAddressFactory extends Factory
{
   protected $model = \Mtc\Shop\Order\Address::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [];
    }

    public function billing()
    {
        return $this->state(function (array $attributes) {
            $gender = fake()->randomElement(['male', 'female']);

            return [
                'type' => 'billing',
                'gender' => $gender,
                'firstname' => $firstname = fake()->firstName(),
                'firstname_hash' => Hash::make($firstname),
                'middle_name' => fake()->firstName,
                'lastname' => $lastname = fake()->lastName(),
                'lastname_hash' => Hash::make($lastname),
                'address1' => fake()->streetAddress(),
                'address2' => '',
                'city' => fake()->city(),
                'state' => '',
                'country' => 'GB',
                'postcode' => $postcode = fake()->postcode(),
                'postcode_hash' => Hash::make($postcode),
                'timestamp' => now(),
                'notes' => '',
            ];
        });
    }

    function shipping()
    {
        return $this->state(function (array $attributes) {
            return [
                'type' => 'shipping',
                'firstname' => $firstname = fake()->firstName(),
                'firstname_hash' => Hash::make($firstname),
                'middle_name' => fake()->firstName,
                'lastname' => $lastname = fake()->lastName(),
                'lastname_hash' => Hash::make($lastname),
                'address1' => fake()->streetAddress(),
                'address2' => '',
                'city' => fake()->city(),
                'state' => '',
                'country' => 'GB',
                'postcode' => $postcode = fake()->postcode(),
                'postcode_hash' => Hash::make($postcode),
                'timestamp' => now(),
                'notes' => '',
            ];
        });
    }
}
