<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grids', function (Blueprint $table) {
            $table->id();
            $table->string('type', 50)->nullable();
            $table->unsignedInteger('page_id');
            $table->string('title', 255);
            $table->dateTime('created_at')->nullable();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->unique('id');
            $table->index('title');
            $table->index('type');
            $table->index('page_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grids');
    }
};
