<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grids_rows', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('grid_id');
            $table->boolean('published')->default(0);
            $table->tinyInteger('order');
            $table->string('css_class', 255);
            $table->dateTime('created_at')->nullable();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->index('grid_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grids_rows');
    }
};
