<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grids_rows_columns', function (Blueprint $table) {
            $table->id(); // auto-increments as UNSIGNED INT by default
            $table->unsignedInteger('grid_row_id');
            $table->tinyInteger('order');
            $table->decimal('width', 10, 2)->unsigned();
            $table->string('css_class', 542);
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->index('grid_row_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grids_rows_columns');
    }
};
