<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grids_rows_columns_data', function (Blueprint $table) {
            $table->id();
            $table->string('parent_id', 255)->nullable();
            $table->string('column_id', 255)->nullable();
            $table->integer('tile_type_id')->nullable();
            $table->string('name', 50)->nullable();
            $table->longText('fields')->nullable();
            $table->string('data', 255)->nullable();
            $table->string('type', 255)->nullable();
            $table->string('template', 255)->nullable();
            $table->dateTime('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->unique('id');
            $table->index('column_id');
            $table->index('name');
            $table->index('parent_id');
            $table->index('tile_type_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grids_rows_columns_data');
    }
};
