<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grid_tile_types', function (Blueprint $table) {
            $table->id();
            $table->string('type', 255)->nullable();
            $table->string('name', 100);
            $table->string('template', 100);
            $table->string('info', 512);
            $table->unsignedTinyInteger('allow_more')->default(0);
            $table->tinyInteger('add_list_item_to_top')->default(0);
            $table->string('more_text', 32);
            $table->tinyInteger('allow_more_max')->default(0);
            $table->tinyInteger('allow_more_min')->default(1);
            $table->boolean('allow_edit')->default(0);

            $table->index('template');
            $table->index('type');
            $table->index('name');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grid_tile_types');
    }
};
