<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migration
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('grid_tile_types_items', function (Blueprint $table) {
            $table->id(); // auto-increment, unsigned by default
            $table->unsignedInteger('grid_tile_type_id');
            $table->string('name', 100);
            $table->text('info');
            $table->integer('order')->default(0);
            $table->string('type', 32);
            $table->string('datatype', 12);
            $table->integer('setup')->default(0);
            $table->boolean('lock')->default(0);
            $table->string('regex', 512);
            $table->string('mime', 255);
            $table->tinyInteger('required')->default(0);
            $table->longText('settings');
            $table->string('css_class', 255);
            $table->longText('options');
            $table->longText('data1');
            $table->longText('data2');
            $table->string('data3', 5);

            $table->index('grid_tile_type_id');
            $table->index('name');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grid_tile_types_items');
    }
};
